/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.common.util;

import java.io.PrintWriter;
import java.io.StringWriter;

public class ExceptionToolkit {
    public static String toString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public static String toString(Throwable t, int maxFrames) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(t);
        int line = 0;
        StackTraceElement[] stackTraceElementArray = t.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            if (++line > maxFrames) {
                pw.println("\t...");
                break;
            }
            pw.println("\tat " + element);
            ++n2;
        }
        pw.close();
        return sw.toString();
    }
}

