/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.common.util;

import java.awt.Color;
import java.awt.GradientPaint;

public class ColorToolkit {
    private static float normalHashValue = "abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz".hashCode();

    private ColorToolkit() {
        throw new UnsupportedOperationException("Do not instantiate toolkit");
    }

    public static String encode(Color color) throws NumberFormatException {
        return "#" + Integer.toHexString((color.getRed() << 16) + (color.getGreen() << 8) + color.getBlue());
    }

    public static Color decode(String hexColor) throws NumberFormatException {
        return Color.decode(hexColor);
    }

    public static Color getDistinguishableColor(Object o) {
        int hash = String.valueOf(o).hashCode();
        float saturation = Math.max(0.4f, Math.min(0.95f, Math.abs((float)hash / normalHashValue)));
        float brightness = Math.max(0.7f, Math.min(0.95f, Math.abs((float)hash / normalHashValue)));
        float hue = (float)((hash + 19) % 30) / 29.0f;
        return Color.getHSBColor(hue, saturation, brightness);
    }

    public static GradientPaint getGradientPaint(Color topColor, int top) {
        Color bottomColor = ColorToolkit.getGradientBottomColor(topColor);
        return new GradientPaint(0.0f, 0.0f, bottomColor, 0.0f, top, topColor);
    }

    public static Color getGradientBottomColor(Color topColor) {
        int r = topColor.getRed();
        int g = topColor.getGreen();
        int b = topColor.getBlue();
        r = ColorToolkit.getGradientComponent(r);
        g = ColorToolkit.getGradientComponent(g);
        b = ColorToolkit.getGradientComponent(b);
        return new Color(r, g, b);
    }

    private static int getGradientComponent(int c) {
        if ((double)c > 191.25) {
            return c - 1;
        }
        if ((double)c > 63.75) {
            return c + 63;
        }
        return c + 127;
    }

    public static Color withAlpha(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static Color blend(Color fg, Color bg) {
        double fga = (double)fg.getAlpha() / 255.0;
        double bga = (double)bg.getAlpha() / 255.0;
        double fgTransparency = 1.0 - fga;
        double r = fga * (double)fg.getRed() + bga * (double)bg.getRed() * fgTransparency;
        double g = fga * (double)fg.getGreen() + bga * (double)bg.getGreen() * fgTransparency;
        double b = fga * (double)fg.getBlue() + bga * (double)bg.getBlue() * fgTransparency;
        double a = fga + bga * fgTransparency;
        return new Color((int)r, (int)g, (int)b, (int)a);
    }
}

