/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.common.unit;

import com.oracle.jmc.common.IDescribable;
import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.item.IAccessorKey;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.messages.internal.Messages;
import com.oracle.jmc.common.unit.ContentType;
import com.oracle.jmc.common.unit.DisplayFormatter;
import com.oracle.jmc.common.unit.IConstraint;
import com.oracle.jmc.common.unit.IFormatter;
import com.oracle.jmc.common.unit.IIncrementalFormatter;
import com.oracle.jmc.common.unit.IPersister;
import com.oracle.jmc.common.unit.IPrefix;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IRange;
import com.oracle.jmc.common.unit.ITypedQuantity;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.LinearUnit;
import com.oracle.jmc.common.unit.QuantityConversionException;
import com.oracle.jmc.common.unit.QuantityRange;
import com.oracle.jmc.common.unit.TypedUnit;
import com.oracle.jmc.common.unit.UnitLookup;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class KindOfQuantity<U extends TypedUnit<U>>
extends ContentType<IQuantity>
implements IPersister<IQuantity> {
    private static IMemberAccessor<Number, IQuantity> DOUBLE_ACCESSOR = new IMemberAccessor<Number, IQuantity>(){

        @Override
        public Number getMember(IQuantity inObject) {
            return inObject.doubleValue();
        }
    };
    private static IMemberAccessor<IUnit, IQuantity> UNIT_ACCESSOR = new IMemberAccessor<IUnit, IQuantity>(){

        @Override
        public IUnit getMember(IQuantity inObject) {
            return inObject.getUnit();
        }
    };
    private final Map<String, U> m_units = new LinkedHashMap<String, U>();

    String resolveLocalizedName(IPrefix<?> prefix, String atomUnitId, String defaultAtomUnitName) {
        String name = Messages.getString("Unit_" + this.getIdentifier() + '_' + prefix.identifier() + atomUnitId + "_name", null);
        if (name == null && defaultAtomUnitName != null) {
            name = String.valueOf(prefix.localizedName()) + defaultAtomUnitName;
        }
        return "".equals(name) ? null : name;
    }

    String resolveLocalizedSymbol(IPrefix<?> prefix, String atomUnitId, String defaultAtomUnitSymbol) {
        String symbol = Messages.getString("Unit_" + this.getIdentifier() + '_' + prefix.identifier() + atomUnitId + "_symbol", null);
        if (symbol == null) {
            symbol = String.valueOf(prefix.symbol()) + defaultAtomUnitSymbol;
        }
        return symbol;
    }

    public static <U extends TypedUnit<U>> String format(Number number, IUnit unit) {
        TypedUnit typedUnit = (TypedUnit)unit;
        IQuantity quantity = typedUnit.quantity(number);
        return typedUnit.getContentType().getDefaultFormatter().format(quantity);
    }

    KindOfQuantity(String identifier) {
        super(identifier);
    }

    KindOfQuantity(String identifier, String localizedName) {
        super(identifier, localizedName);
    }

    public abstract KindOfQuantity<LinearUnit> getDeltaKind();

    public abstract U getDefaultUnit();

    protected void addUnit(U unit) {
        assert (unit.getIdentifier() != null);
        U existing = this.m_units.put(unit.getIdentifier(), unit);
        assert (existing == null);
    }

    public Collection<? extends U> getCommonUnits() {
        return this.m_units.values();
    }

    public Collection<? extends U> getAllUnits() {
        return this.m_units.values();
    }

    public U getUnit(String id) {
        return (U)((TypedUnit)this.m_units.get(id));
    }

    @Override
    public IPersister<IQuantity> getPersister() {
        return this;
    }

    @Override
    public IConstraint<IQuantity> combine(IConstraint<?> other) {
        if (this == other) {
            return this;
        }
        if (other instanceof ContentType) {
            return null;
        }
        IConstraint<IQuantity> combo = other.combine(this);
        return combo;
    }

    @Override
    public boolean validate(IQuantity value) {
        if (value.getType() != this) {
            throw new IllegalArgumentException(String.valueOf(value.persistableString()) + " isn't of the kind " + this.getIdentifier());
        }
        return false;
    }

    @Override
    public String persistableString(IQuantity value) {
        this.validate(value);
        return value.persistableString();
    }

    @Override
    public abstract ITypedQuantity<U> parsePersisted(String var1) throws QuantityConversionException;

    @Override
    public String interactiveFormat(IQuantity value) {
        this.validate(value);
        return value.interactiveFormat();
    }

    @Override
    public abstract ITypedQuantity<U> parseInteractive(String var1) throws QuantityConversionException;

    public abstract U getPreferredUnit(IQuantity var1, double var2, double var4);

    public abstract U getLargestExactUnit(IQuantity var1);

    public final IRange<IQuantity> getFirstBucket(IQuantity start, IQuantity end, double maxBuckets) {
        if (start.getType() != this || end.getType() != this) {
            throw new IllegalArgumentException(String.valueOf(start.persistableString()) + " and " + end.persistableString() + " both needs to be of the kind " + this.getIdentifier());
        }
        ITypedQuantity typedStart = (ITypedQuantity)start;
        ITypedQuantity typedEnd = (ITypedQuantity)end;
        return this.getFirstBucket(typedStart, typedEnd, maxBuckets);
    }

    protected IRange<IQuantity> getFirstBucket(ITypedQuantity<U> start, ITypedQuantity<U> end, double maxBuckets) {
        assert (maxBuckets > 0.0);
        ITypedQuantity<LinearUnit> delta = end.subtract(start);
        assert (delta.doubleValue() > 0.0);
        ITypedQuantity<LinearUnit> maxExtent = delta.multiply(2.0 / maxBuckets);
        ITypedQuantity<LinearUnit> extent = maxExtent.getUnit().getContentType().snapToBestBetweenHalfAndEqual(maxExtent);
        ITypedQuantity<U> alignedStart = start.floorQuantize(extent);
        return QuantityRange.createWithExtent(alignedStart, extent);
    }

    public IFormatter<IRange<IQuantity>> getRangeFormatter(final String formatHint) {
        if ("exact".equals(formatHint) || "verbose".equals(formatHint)) {
            return new IFormatter<IRange<IQuantity>>(){

                @Override
                public String format(IRange<IQuantity> range) {
                    IFormatter<IQuantity> formatter = KindOfQuantity.this.getFormatterResolving(range);
                    if (formatter instanceof IIncrementalFormatter) {
                        IIncrementalFormatter changeFormat = (IIncrementalFormatter)formatter;
                        IQuantity start = range.getStart();
                        return String.valueOf(changeFormat.formatAdjacent(null, start)) + " \u2013 (" + range.getExtent().displayUsing(formatHint) + ") \u2013 " + changeFormat.formatAdjacent(start, range.getEnd());
                    }
                    return String.valueOf(formatter.format(range.getStart())) + " \u2013 (" + range.getExtent().displayUsing(formatHint) + ") \u2013 " + formatter.format(range.getEnd());
                }
            };
        }
        return new IFormatter<IRange<IQuantity>>(){

            @Override
            public String format(IRange<IQuantity> range) {
                IFormatter<IQuantity> formatter = KindOfQuantity.this.getFormatterResolving(range);
                if (formatter instanceof IIncrementalFormatter) {
                    IIncrementalFormatter changeFormat = (IIncrementalFormatter)formatter;
                    IQuantity start = range.getStart();
                    return String.valueOf(changeFormat.formatAdjacent(null, start)) + " \u2013 " + changeFormat.formatAdjacent(start, range.getEnd());
                }
                return String.valueOf(formatter.format(range.getStart())) + " \u2013 " + formatter.format(range.getEnd());
            }
        };
    }

    public abstract IFormatter<IQuantity> getFormatterResolving(IRange<IQuantity> var1);

    @Override
    public List<IAttribute<?>> getAttributes() {
        return Arrays.asList(UnitLookup.NUMERICAL_ATTRIBUTE, UnitLookup.UNIT_ATTRIBUTE);
    }

    @Override
    public Map<IAccessorKey<?>, ? extends IDescribable> getAccessorKeys() {
        HashMap keys = new HashMap();
        keys.put(UnitLookup.NUMERICAL_ATTRIBUTE.getKey(), UnitLookup.NUMERICAL_ATTRIBUTE);
        keys.put(UnitLookup.UNIT_ATTRIBUTE.getKey(), UnitLookup.UNIT_ATTRIBUTE);
        return keys;
    }

    @Override
    public <M> IMemberAccessor<M, IQuantity> getAccessor(IAccessorKey<M> attribute) {
        if (UnitLookup.NUMERICAL_ATTRIBUTE.getKey().equals(attribute)) {
            return DOUBLE_ACCESSOR;
        }
        if (UnitLookup.UNIT_ATTRIBUTE.getKey().equals(attribute)) {
            return UNIT_ACCESSOR;
        }
        return null;
    }

    public static class ExactFormatter<U extends TypedUnit<U>>
    extends DisplayFormatter<IQuantity> {
        protected ExactFormatter(KindOfQuantity<U> kindOfQuantity) {
            this(kindOfQuantity, "Exact");
        }

        protected ExactFormatter(KindOfQuantity<U> kindOfQuantity, String name) {
            super(kindOfQuantity, "exact", name);
        }

        @Override
        public String format(IQuantity quantity) {
            ITypedQuantity typedQuantity = (ITypedQuantity)quantity;
            return typedQuantity.localizedFormat(false, true);
        }
    }

    public static class VerboseFormatter<U extends TypedUnit<U>>
    extends DisplayFormatter<IQuantity> {
        protected VerboseFormatter(KindOfQuantity<U> kindOfQuantity) {
            this(kindOfQuantity, "Verbose");
        }

        protected VerboseFormatter(KindOfQuantity<U> kindOfQuantity, String name) {
            super(kindOfQuantity, "verbose", name);
        }

        @Override
        public String format(IQuantity quantity) {
            LinearUnit unit;
            ITypedQuantity typedQuantity = (ITypedQuantity)quantity;
            if (quantity.getUnit() instanceof LinearUnit && (unit = (LinearUnit)quantity.getUnit()).isCustom()) {
                return String.valueOf(typedQuantity.localizedFormat(false, true)) + " \u2248 " + typedQuantity.localizedFormat(false, false);
            }
            return typedQuantity.localizedFormat(false, false);
        }
    }
}

