/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.common.unit;

import com.oracle.jmc.common.unit.ScaleFactor;

public class ImpreciseScaleFactor
extends ScaleFactor {
    private final Number numberFactor;

    public ImpreciseScaleFactor(Number factor) {
        this.numberFactor = factor;
    }

    @Override
    public ScaleFactor concat(ScaleFactor innerFactor) {
        if (innerFactor.isUnity()) {
            return this;
        }
        return new ImpreciseScaleFactor(innerFactor.targetValue(this.numberFactor.doubleValue()));
    }

    @Override
    public ScaleFactor invert() {
        return new ImpreciseScaleFactor(1.0 / this.numberFactor.doubleValue());
    }

    @Override
    public boolean targetOutOfRange(long srcNumericalValue, long maxAbsValue) {
        if (this.numberFactor.doubleValue() >= 1.0) {
            if (srcNumericalValue >= 0L) {
                return (double)srcNumericalValue > (double)maxAbsValue / this.getMultiplier();
            }
            return (double)srcNumericalValue < (double)(maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL) / this.getMultiplier();
        }
        if (srcNumericalValue >= 0L) {
            return this.targetValue(srcNumericalValue) > maxAbsValue;
        }
        return this.targetValue(srcNumericalValue) < (maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public boolean targetOutOfRange(double srcNumericalValue, long maxAbsValue) {
        if (this.numberFactor.doubleValue() >= 1.0) {
            if (srcNumericalValue >= 0.0) {
                return srcNumericalValue > (double)maxAbsValue / this.getMultiplier();
            }
            return srcNumericalValue < (double)(maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL) / this.getMultiplier();
        }
        if (srcNumericalValue >= 0.0) {
            return this.targetValue(srcNumericalValue) > (double)maxAbsValue;
        }
        return this.targetValue(srcNumericalValue) < (double)(maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public double targetValue(double srcNumericalValue) {
        return srcNumericalValue * this.numberFactor.doubleValue();
    }

    @Override
    public long targetValue(long srcNumericalValue) {
        return Math.round((double)srcNumericalValue * this.numberFactor.doubleValue());
    }

    @Override
    public long targetFloor(long srcNumericalValue) {
        return (long)Math.floor((double)srcNumericalValue * this.numberFactor.doubleValue());
    }

    @Override
    public Number targetNumber(long srcNumericalValue) {
        return this.targetValue((double)srcNumericalValue);
    }

    @Override
    public Number targetNumber(Number srcNumericalValue) {
        return this.targetValue(srcNumericalValue.doubleValue());
    }

    @Override
    public boolean isUnity() {
        return false;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ImpreciseScaleFactor && this.numberFactor.equals(((ImpreciseScaleFactor)other).numberFactor);
    }

    @Override
    public int hashCode() {
        return this.numberFactor.hashCode();
    }

    public String toString() {
        return this.numberFactor.toString();
    }

    @Override
    public double getMultiplier() {
        return this.numberFactor.doubleValue();
    }
}

