/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.common.unit;

import com.oracle.jmc.common.unit.ITypedQuantity;
import com.oracle.jmc.common.unit.LinearKindOfQuantity;
import com.oracle.jmc.common.unit.LinearUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.SortedSet;

public class CustomUnitSelector
implements LinearKindOfQuantity.LinearUnitSelector {
    protected final LinearKindOfQuantity kindOfQuantity;
    protected final double[] unitMultiplierArr;
    protected final LinearUnit[] unitArr;
    protected final double[] tickMultiplierArr;
    protected final ArrayList<ITypedQuantity<LinearUnit>> tickList;
    protected final LinearKindOfQuantity.LinearUnitSelector smallSelector;
    protected final LinearKindOfQuantity.LinearUnitSelector bigSelector;

    public CustomUnitSelector(LinearKindOfQuantity kindOfQuantity, LinearKindOfQuantity.LinearUnitSelector smallSelector, Collection<LinearUnit> units, LinearKindOfQuantity.LinearUnitSelector bigSelector, SortedSet<ITypedQuantity<LinearUnit>> ticks) {
        this.kindOfQuantity = kindOfQuantity;
        this.smallSelector = smallSelector;
        this.bigSelector = bigSelector;
        this.unitArr = units.toArray(new LinearUnit[units.size()]);
        Arrays.sort(this.unitArr);
        this.unitMultiplierArr = new double[this.unitArr.length];
        int i = 0;
        while (i < this.unitArr.length) {
            this.unitMultiplierArr[i] = this.unitArr[i].valueTransformTo(kindOfQuantity.atomUnit).getMultiplier();
            ++i;
        }
        this.tickList = new ArrayList<ITypedQuantity<LinearUnit>>(ticks);
        this.tickMultiplierArr = new double[this.tickList.size()];
        i = 0;
        while (i < this.tickMultiplierArr.length) {
            this.tickMultiplierArr[i] = this.tickList.get(i).doubleValueIn(kindOfQuantity.atomUnit);
            if (i > 0 && this.tickMultiplierArr[i] > this.tickMultiplierArr[i - 1] * 2.0) {
                throw new IllegalArgumentException("Tick with growth factor > 2: " + this.tickList.get(i));
            }
            ++i;
        }
        this.tickList.add(0, this.tickList.get(0));
    }

    @Override
    public LinearUnit getPreferredUnit(ITypedQuantity<LinearUnit> quantity, double minNumericalValue, double maxNumericalValue) {
        double scaledVal;
        LinearUnit atomUnit = this.kindOfQuantity.atomUnit;
        double absVal = Math.abs(quantity.doubleValueIn(atomUnit));
        double d = scaledVal = minNumericalValue > 1.0 ? absVal / minNumericalValue : absVal;
        if (scaledVal < this.unitMultiplierArr[0]) {
            return this.smallSelector.getPreferredUnit(quantity, minNumericalValue, maxNumericalValue);
        }
        if (absVal < this.unitMultiplierArr[this.unitArr.length - 1] * maxNumericalValue) {
            int i = 1;
            while (i < this.unitMultiplierArr.length) {
                if (scaledVal < this.unitMultiplierArr[i]) {
                    return this.unitArr[i - 1];
                }
                ++i;
            }
            return this.unitArr[this.unitArr.length - 1];
        }
        return this.bigSelector.getPreferredUnit(quantity, minNumericalValue, maxNumericalValue);
    }

    @Override
    public ITypedQuantity<LinearUnit> snapToBestBetweenHalfAndEqual(ITypedQuantity<LinearUnit> upperLimit) {
        assert (Math.abs(upperLimit.doubleValue()) > 0.0);
        double absVal = Math.abs(upperLimit.doubleValueIn(this.kindOfQuantity.atomUnit));
        if (absVal < this.tickMultiplierArr[0]) {
            return this.smallSelector.snapToBestBetweenHalfAndEqual(upperLimit);
        }
        if (absVal > this.tickMultiplierArr[this.tickMultiplierArr.length - 1]) {
            return this.bigSelector.snapToBestBetweenHalfAndEqual(upperLimit);
        }
        int pos = Arrays.binarySearch(this.tickMultiplierArr, absVal);
        if (pos < 0) {
            pos = -1 - pos;
        }
        return this.tickList.get(pos);
    }

    @Override
    public LinearUnit getLargestExactUnit(ITypedQuantity<LinearUnit> quantity) {
        int pos;
        if (quantity.doubleValue() == 0.0) {
            return quantity.getUnit();
        }
        double absVal = Math.abs(quantity.doubleValueIn(this.kindOfQuantity.atomUnit));
        if (absVal < this.unitMultiplierArr[0]) {
            return this.smallSelector.getLargestExactUnit(quantity);
        }
        if (absVal > this.unitMultiplierArr[this.unitMultiplierArr.length - 1]) {
            LinearUnit bigUnit = this.bigSelector.getLargestExactUnit(quantity);
            if (bigUnit != null) {
                return bigUnit;
            }
            pos = this.unitMultiplierArr.length - 1;
        } else {
            pos = Arrays.binarySearch(this.unitMultiplierArr, absVal);
            if (pos >= 0) {
                return this.unitArr[pos];
            }
            pos = -1 - pos;
        }
        while (pos >= 0) {
            if (absVal % this.unitMultiplierArr[pos] == 0.0) {
                return this.unitArr[pos];
            }
            --pos;
        }
        return this.smallSelector.getLargestExactUnit(quantity);
    }
}

