/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.common.unit;

import com.oracle.jmc.common.IDescribable;
import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.item.IAccessorKey;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.ICanonicalAccessorFactory;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.common.messages.internal.Messages;
import com.oracle.jmc.common.unit.DisplayFormatter;
import com.oracle.jmc.common.unit.IFormatter;
import com.oracle.jmc.common.unit.IPersister;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ContentType<T>
implements IType<T> {
    private final List<DisplayFormatter<T>> m_formatters = new ArrayList<DisplayFormatter<T>>();
    protected final String m_identifier;
    private final String m_localizedName;

    ContentType(String identifier) {
        this(identifier, ContentType.lookupNameFor(identifier));
    }

    public ContentType(String identifier, String localizedName) {
        this.m_identifier = identifier;
        this.m_localizedName = localizedName;
    }

    protected void addFormatter(DisplayFormatter<T> formatter) {
        this.m_formatters.add(formatter);
    }

    public List<DisplayFormatter<T>> getFormatters() {
        return Collections.unmodifiableList(this.m_formatters);
    }

    public IFormatter<T> getDefaultFormatter() {
        return this.m_formatters.get(0);
    }

    @Override
    public String getName() {
        return this.m_localizedName;
    }

    @Override
    public String getIdentifier() {
        return this.m_identifier;
    }

    public IPersister<T> getPersister() {
        return null;
    }

    public IFormatter<T> getFormatter(String formatterIdentifier) {
        for (DisplayFormatter<T> formatter : this.m_formatters) {
            if (!formatterIdentifier.equals(formatter.getIdentifier())) continue;
            return formatter;
        }
        return this.m_formatters.get(0);
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public List<IAttribute<?>> getAttributes() {
        return Collections.emptyList();
    }

    @Override
    public Map<IAccessorKey<?>, ? extends IDescribable> getAccessorKeys() {
        return Collections.emptyMap();
    }

    @Override
    public boolean hasAttribute(ICanonicalAccessorFactory<?> attribute) {
        return attribute.getAccessor(this) != null;
    }

    @Override
    public <M> IMemberAccessor<M, T> getAccessor(IAccessorKey<M> attribute) {
        return null;
    }

    public String toString() {
        return "Type(" + this.m_identifier + ')';
    }

    protected static String lookupNameFor(String typeIdentifier) {
        return Messages.getString("ContentType_" + typeIdentifier);
    }
}

