/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.common.unit;

import com.oracle.jmc.common.unit.IConstraint;
import com.oracle.jmc.common.unit.IFormatter;
import com.oracle.jmc.common.unit.IPersister;
import com.oracle.jmc.common.unit.QuantitiesToolkit;
import com.oracle.jmc.common.unit.QuantityConversionException;

public final class ComparableConstraint<T extends Comparable<T>>
implements IConstraint<T>,
IFormatter<T> {
    private final IPersister<T> persister;
    private final T min;
    private final T max;

    public static <U, T extends Comparable<T>> IConstraint<U> constrain(IConstraint<U> constraint, String persistedMin, String persistedMax) throws QuantityConversionException {
        Object max;
        Object min;
        try {
            min = persistedMin != null ? constraint.parsePersisted(persistedMin) : null;
        }
        catch (QuantityConversionException e) {
            if (e.getProblem() != QuantityConversionException.Problem.TOO_LOW) {
                throw e;
            }
            min = null;
        }
        try {
            max = persistedMax != null ? constraint.parsePersisted(persistedMax) : null;
        }
        catch (QuantityConversionException e) {
            if (e.getProblem() != QuantityConversionException.Problem.TOO_HIGH) {
                throw e;
            }
            max = null;
        }
        if (min == null && max == null) {
            return constraint;
        }
        if (min instanceof Comparable || max instanceof Comparable) {
            IConstraint<Comparable> result = ComparableConstraint.constrainComparable(constraint, min, max);
            return result;
        }
        return null;
    }

    public static <U, T extends Comparable<T>> IConstraint<U> constrain(IConstraint<U> constraint, U min, U max) {
        if (min instanceof Comparable || max instanceof Comparable) {
            IConstraint<Comparable> result = ComparableConstraint.constrainComparable(constraint, (Comparable)min, (Comparable)max);
            return result;
        }
        return null;
    }

    private static <T extends Comparable<T>> IConstraint<T> constrainComparable(IConstraint<T> constraint, T min, T max) {
        if (min == null && max == null) {
            return constraint;
        }
        if (constraint instanceof IPersister) {
            return new ComparableConstraint<T>((IPersister)constraint, min, max);
        }
        if (constraint instanceof ComparableConstraint) {
            ComparableConstraint cc = (ComparableConstraint)constraint;
            return cc.constrain(min, max);
        }
        return null;
    }

    public ComparableConstraint(IPersister<T> persister, T min, T max) {
        this.persister = persister;
        this.min = min;
        this.max = max;
    }

    private IConstraint<T> constrain(T otherMin, T otherMax) {
        T newMin = QuantitiesToolkit.minPresent(this.min, otherMin);
        T newMax = QuantitiesToolkit.maxPresent(this.max, otherMax);
        if (newMin == null || newMax == null || newMin.compareTo(newMax) <= 0) {
            if (QuantitiesToolkit.same(newMin, this.min) && QuantitiesToolkit.same(newMax, this.max)) {
                return this;
            }
            return new ComparableConstraint<T>(this.persister, newMin, newMax);
        }
        return null;
    }

    @Override
    public ComparableConstraint<T> combine(IConstraint<?> other) {
        if (other == this || other == this.persister) {
            return this;
        }
        if (other instanceof ComparableConstraint && ((ComparableConstraint)other).persister == this.persister) {
            ComparableConstraint otherCC = (ComparableConstraint)other;
            return this.combineNonSame(otherCC);
        }
        return null;
    }

    protected ComparableConstraint<T> combineNonSame(ComparableConstraint<T> other) {
        T newMin = QuantitiesToolkit.minPresent(this.min, other.min);
        T newMax = QuantitiesToolkit.maxPresent(this.max, other.max);
        if (newMin == null || newMax == null || newMin.compareTo(newMax) <= 0) {
            if (QuantitiesToolkit.same(newMin, this.min) && QuantitiesToolkit.same(newMax, this.max)) {
                return this;
            }
            if (QuantitiesToolkit.same(newMin, other.min) && QuantitiesToolkit.same(newMax, other.max)) {
                return other;
            }
            return new ComparableConstraint<T>(this.persister, newMin, newMax);
        }
        return null;
    }

    @Override
    public boolean validate(T value) throws QuantityConversionException {
        return this.persister.validate(value) || this.validateRange(value);
    }

    protected boolean validateRange(T value) throws QuantityConversionException {
        if (this.min != null && this.min.compareTo(value) > 0) {
            throw QuantityConversionException.tooLow(value, this.min, this.persister);
        }
        if (this.max != null && this.max.compareTo(value) < 0) {
            throw QuantityConversionException.tooHigh(value, this.max, this.persister);
        }
        return false;
    }

    @Override
    public String persistableString(T value) throws QuantityConversionException {
        this.validate(value);
        return this.persister.persistableString(value);
    }

    @Override
    public T parsePersisted(String persistedValue) throws QuantityConversionException {
        Comparable value = (Comparable)this.persister.parsePersisted(persistedValue);
        this.validate((T)value);
        return (T)value;
    }

    @Override
    public String interactiveFormat(T value) throws QuantityConversionException {
        this.validate(value);
        return this.persister.interactiveFormat(value);
    }

    @Override
    public T parseInteractive(String interactiveValue) throws QuantityConversionException {
        Comparable value = (Comparable)this.persister.parseInteractive(interactiveValue);
        this.validate((T)value);
        return (T)value;
    }

    @Override
    public String format(T value) {
        if (this.persister instanceof IFormatter) {
            IFormatter formatter = (IFormatter)((Object)this.persister);
            return formatter.format(value);
        }
        return this.persister.interactiveFormat(value);
    }
}

