/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.common.unit;

import com.oracle.jmc.common.messages.internal.Messages;
import com.oracle.jmc.common.unit.BinaryScaleFactor;
import com.oracle.jmc.common.unit.BinaryUnitSelector;
import com.oracle.jmc.common.unit.DecimalPrefix;
import com.oracle.jmc.common.unit.IPrefix;
import com.oracle.jmc.common.unit.LinearKindOfQuantity;
import java.util.Locale;

public final class BinaryPrefix
extends Enum<BinaryPrefix>
implements IPrefix<BinaryPrefix> {
    public static final /* enum */ BinaryPrefix NOBI = new BinaryPrefix();
    public static final /* enum */ BinaryPrefix KIBI = new BinaryPrefix(1, 'k');
    public static final /* enum */ BinaryPrefix MEBI = new BinaryPrefix(2, 'M');
    public static final /* enum */ BinaryPrefix GIBI = new BinaryPrefix(3, 'G');
    public static final /* enum */ BinaryPrefix TEBI = new BinaryPrefix(4, 'T');
    public static final /* enum */ BinaryPrefix PEBI = new BinaryPrefix(5, 'P');
    public static final /* enum */ BinaryPrefix EXBI = new BinaryPrefix(6, 'E');
    public static final /* enum */ BinaryPrefix ZEBI = new BinaryPrefix(7, 'Z');
    public static final /* enum */ BinaryPrefix YOBI = new BinaryPrefix(8, 'Y');
    private static BinaryPrefix[] PREFIXES;
    private final int shift;
    private final BinaryScaleFactor scaleFactor;
    @Deprecated
    public final DecimalPrefix prefixSI;
    public final String symbolSI;
    public final String symbolJEDEC;
    public final String symbolIEC;
    public final String englishName;
    public final String localizedName;
    private static final /* synthetic */ BinaryPrefix[] ENUM$VALUES;

    static {
        ENUM$VALUES = new BinaryPrefix[]{NOBI, KIBI, MEBI, GIBI, TEBI, PEBI, EXBI, ZEBI, YOBI};
        PREFIXES = BinaryPrefix.values();
    }

    private BinaryPrefix() {
        assert (this.ordinal() == 0) : "Implementation error in enum: (ordinal = " + this.ordinal() + ") != 0";
        this.shift = 0;
        this.scaleFactor = BinaryScaleFactor.get(0);
        this.prefixSI = DecimalPrefix.NONE;
        this.symbolSI = "";
        this.symbolJEDEC = "";
        this.symbolIEC = "";
        this.englishName = "";
        this.localizedName = "";
    }

    private BinaryPrefix(int powerOf1024, char charSI) {
        assert (powerOf1024 == this.ordinal()) : "Implementation error in enum: (ordinal = " + this.ordinal() + ") != (powerOf1024 = " + powerOf1024 + ')';
        this.shift = powerOf1024 * 10;
        this.scaleFactor = BinaryScaleFactor.get(this.shift);
        this.symbolSI = String.valueOf(charSI);
        this.prefixSI = DecimalPrefix.getPrefix(this.symbolSI);
        assert (this.prefixSI != null);
        this.symbolJEDEC = this.symbolSI.toUpperCase(Locale.ENGLISH);
        this.symbolIEC = String.valueOf(this.symbolJEDEC) + 'i';
        this.englishName = this.name().toLowerCase(Locale.ENGLISH);
        this.localizedName = Messages.getString("Prefix_" + this.symbolIEC + "_name", this.englishName);
    }

    public int shift() {
        return this.shift;
    }

    public int log1024() {
        return this.ordinal();
    }

    public long convertTo(long value) {
        return this.shift > 63 ? 0L : value >> this.shift;
    }

    public float convertTo(float value) {
        return Math.scalb(value, -this.shift);
    }

    public double convertTo(double value) {
        return Math.scalb(value, -this.shift);
    }

    public static int getFloorLog2(long value) {
        if (value == 0L) {
            return 0;
        }
        return 63 - Long.numberOfLeadingZeros(Math.abs(value));
    }

    public static int getFloorLog1024(long value) {
        return (63 - Long.numberOfLeadingZeros(Math.abs(value))) / 10;
    }

    public static BinaryPrefix getFloorPrefix(long value) {
        return PREFIXES[BinaryPrefix.getFloorLog1024(value)];
    }

    public static int getAlignmentLog2(long value) {
        return Long.numberOfTrailingZeros(value);
    }

    public static int getAlignmentLog1024(long value) {
        return BinaryPrefix.getAlignmentLog2(value) / 10;
    }

    public static int getFloorLog2(double value) {
        if (value == 0.0) {
            return 0;
        }
        return Math.getExponent(value);
    }

    private static int floorDiv10(int value) {
        if (value < 0) {
            return ~(~value / 10);
        }
        return value / 10;
    }

    public static int getFloorLog1024(double value) {
        return BinaryPrefix.floorDiv10(BinaryPrefix.getFloorLog2(value));
    }

    public static BinaryPrefix getFloorPrefix(double value) {
        int log1024 = BinaryPrefix.getFloorLog1024(value);
        return PREFIXES[Math.max(0, Math.min(log1024, PREFIXES.length - 1))];
    }

    public static int getAlignmentLog2(double value) {
        long bits = Double.doubleToRawLongBits(value);
        long mantissa = (bits & 0xFFFFFFFFFFFFFL) + 0x10000000000000L;
        return Long.numberOfTrailingZeros(mantissa) - 52 + Math.getExponent(value);
    }

    public static int getAlignmentLog1024(double value) {
        return BinaryPrefix.floorDiv10(BinaryPrefix.getAlignmentLog2(value));
    }

    @Override
    public String identifier() {
        return this.symbolIEC;
    }

    @Override
    public String symbol() {
        return this.symbolIEC;
    }

    @Override
    public String altSymbol() {
        return this.symbolJEDEC;
    }

    @Override
    public String localizedName() {
        return this.localizedName;
    }

    @Override
    public StringBuilder asExponentialStringBuilder(boolean multiplicationSign) {
        return this.scaleFactor.asExponentialStringBuilder(multiplicationSign);
    }

    @Override
    public BinaryScaleFactor scaleFactor() {
        return this.scaleFactor;
    }

    public BinaryScaleFactor valueFactorTo(BinaryPrefix targetPrefix) {
        return BinaryScaleFactor.get(this.shift - targetPrefix.shift);
    }

    @Override
    public LinearKindOfQuantity.LinearUnitSelector createUnitSelector(LinearKindOfQuantity kindOfQuantity, Iterable<BinaryPrefix> prefixes) {
        return new BinaryUnitSelector(kindOfQuantity, prefixes);
    }

    public static BinaryPrefix[] values() {
        BinaryPrefix[] binaryPrefixArray = ENUM$VALUES;
        int n = binaryPrefixArray.length;
        BinaryPrefix[] binaryPrefixArray2 = new BinaryPrefix[n];
        System.arraycopy(ENUM$VALUES, 0, binaryPrefixArray2, 0, n);
        return binaryPrefixArray2;
    }

    public static BinaryPrefix valueOf(String string) {
        return Enum.valueOf(BinaryPrefix.class, string);
    }
}

