/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.common.item;

import com.oracle.jmc.common.item.IAggregator;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.IItemFilter;
import com.oracle.jmc.common.item.IItemQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class ItemQueryBuilder {
    private ItemQuery query;

    private ItemQueryBuilder(IItemFilter filter) {
        this.query = new ItemQuery(filter);
    }

    private ItemQuery getQuery() {
        if (this.query == null) {
            throw new IllegalStateException("Query already built. ItemQueryBuilder cannot be reused.");
        }
        return this.query;
    }

    public ItemQueryBuilder select(IAttribute<?> ... attributes) {
        IAttribute<?>[] iAttributeArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute<?> attribute = iAttributeArray[n2];
            this.select(attribute);
            ++n2;
        }
        return this;
    }

    public ItemQueryBuilder select(IAggregator<?, ?> ... aggregators) {
        IAggregator<?, ?>[] iAggregatorArray = aggregators;
        int n = aggregators.length;
        int n2 = 0;
        while (n2 < n) {
            IAggregator<?, ?> aggregator = iAggregatorArray[n2];
            this.select(aggregator);
            ++n2;
        }
        return this;
    }

    public ItemQueryBuilder select(IAttribute<?> attribute) {
        this.getQuery().fields.add(attribute);
        return this;
    }

    public ItemQueryBuilder select(IAggregator<?, ?> aggregator) {
        this.getQuery().aggregators.add(aggregator);
        return this;
    }

    public ItemQueryBuilder groupBy(IAttribute<?> attribute) {
        this.getQuery().groupBy = attribute;
        return this;
    }

    public static ItemQueryBuilder fromWhere(IItemFilter filter) {
        return new ItemQueryBuilder(filter);
    }

    public IItemQuery build() {
        ItemQuery q = this.query;
        this.query = null;
        q.fields = Collections.unmodifiableCollection(q.fields);
        q.aggregators = Collections.unmodifiableCollection(q.aggregators);
        return q;
    }

    private static class ItemQuery
    implements IItemQuery {
        private final IItemFilter filter;
        private Collection<IAttribute<?>> fields = new ArrayList();
        private Collection<IAggregator<?, ?>> aggregators = new ArrayList();
        private IAttribute<?> groupBy;

        ItemQuery(IItemFilter filter) {
            this.filter = filter;
        }

        @Override
        public IItemFilter getFilter() {
            return this.filter;
        }

        @Override
        public Collection<IAttribute<?>> getAttributes() {
            return this.fields;
        }

        @Override
        public IAttribute<?> getGroupBy() {
            return this.groupBy;
        }

        @Override
        public Collection<IAggregator<?, ?>> getAggregators() {
            return this.aggregators;
        }
    }
}

