/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.common.item;

import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.item.IAccessorFactory;
import com.oracle.jmc.common.item.IItem;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.common.item.ItemToolkit;
import java.util.HashMap;
import java.util.Map;

class CachingAccessor<T>
implements IMemberAccessor<T, IItem> {
    private final IAccessorFactory<T> attribute;
    private final Map<IType<?>, IMemberAccessor<? extends T, IItem>> fieldsToMerge = new HashMap();
    private IType<IItem> lastType;
    private IMemberAccessor<? extends T, IItem> lastField;

    CachingAccessor(IAccessorFactory<T> attribute) {
        this.attribute = attribute;
    }

    @Override
    public T getMember(IItem inObject) {
        if (inObject != null) {
            if (this.lastType != inObject.getType()) {
                this.lastType = ItemToolkit.getItemType(inObject);
                this.lastField = this.fieldsToMerge.get(this.lastType);
                if (this.lastField == null && !this.fieldsToMerge.containsKey(this.lastType)) {
                    this.lastField = this.attribute.getAccessor(this.lastType);
                    this.fieldsToMerge.put(this.lastType, this.lastField);
                }
            }
            return this.lastField == null ? null : (T)this.lastField.getMember(inObject);
        }
        return null;
    }
}

