/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.common.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Collection;
import java.util.HashSet;

public class ValidatingObjectInputStream
extends ObjectInputStream {
    private LimitedInputStream in;
    private Collection<Class<?>> safeClasses = null;
    private int maxObjects = 0;
    private int readObjects = 0;

    private ValidatingObjectInputStream(LimitedInputStream in) throws IOException {
        super(in);
        this.in = in;
        this.enableResolveObject(true);
    }

    public static ValidatingObjectInputStream build(InputStream in) throws IOException {
        LimitedInputStream lin = new LimitedInputStream(in, 4L);
        return new ValidatingObjectInputStream(lin);
    }

    public <T> T safeReadObject(Class<T> type, Collection<Class<?>> safeClasses, int maxObjects, long maxBytes) throws ClassNotFoundException, IOException, ClassCastException {
        HashSet typeAndSafeClasses = new HashSet();
        typeAndSafeClasses.add(type);
        if (safeClasses != null) {
            typeAndSafeClasses.addAll(safeClasses);
        }
        this.updateValidation(typeAndSafeClasses, maxObjects, maxBytes);
        Object obj = this.readObject();
        this.zeroValidation();
        return (T)obj;
    }

    public long safeReadLong() throws IOException {
        this.updateValidation(null, 0, 10L);
        return super.readLong();
    }

    private void updateValidation(Collection<Class<?>> safeClasses, int maxObjects, long maxBytes) {
        this.safeClasses = safeClasses;
        this.maxObjects = maxObjects;
        this.readObjects = 0;
        this.in.updateValidation(maxBytes);
    }

    private void zeroValidation() {
        this.safeClasses = null;
        this.maxObjects = 0;
        this.in.updateValidation(0L);
    }

    @Override
    protected Object resolveObject(Object obj) throws IOException {
        if (this.readObjects++ > this.maxObjects) {
            throw new SecurityException("Attempting to deserialize too many objects from stream, limit=" + this.maxObjects);
        }
        return super.resolveObject(obj);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        Class<?> clazz = super.resolveClass(desc);
        if (this.safeClasses != null && (this.safeClasses.contains(clazz) || clazz.isArray())) {
            return clazz;
        }
        throw new SecurityException("Attempting to deserialize non-whitelisted class: " + clazz.getName());
    }

    private static class LimitedInputStream
    extends FilterInputStream {
        private long maxBytes;
        private long readBytes = 0L;

        public LimitedInputStream(InputStream in, long maxBytes) {
            super(in);
            this.maxBytes = maxBytes;
        }

        @Override
        public int read() throws IOException {
            this.checkLength(1);
            int val = super.read();
            if (val != -1) {
                ++this.readBytes;
            }
            return val;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.checkLength(len);
            int val = super.read(b, off, len);
            if (val > 0) {
                this.readBytes += (long)val;
            }
            return val;
        }

        private void checkLength(int len) {
            if (this.readBytes + (long)len > this.maxBytes) {
                throw new SecurityException("Attempting to read too many bytes from stream, read=" + (this.readBytes + (long)len) + " limit=" + this.maxBytes);
            }
        }

        public void updateValidation(long maxBytes) {
            this.maxBytes = maxBytes;
            this.readBytes = 0L;
        }
    }
}

