/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.common.collection;

import com.oracle.jmc.common.collection.IteratorToolkit;
import java.util.Arrays;
import java.util.Iterator;

public class SimpleArray<T>
implements Iterable<T> {
    private T[] elements;
    private int size;

    public SimpleArray(T[] initial) {
        this(initial, 0);
    }

    public SimpleArray(T[] initial, int size) {
        this.elements = initial;
        this.size = size;
        if (initial.length < size || size < 0) {
            throw new IllegalArgumentException("Can't create SimpleArray length=" + initial.length + " size=" + size);
        }
    }

    public T get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.elements[index];
    }

    public void add(T element) {
        if (this.size + 1 > this.elements.length) {
            this.elements = Arrays.copyOf(this.elements, Math.max(this.calculateNewCapacity(this.elements.length), 3));
        }
        this.elements[this.size++] = element;
    }

    public void add(T[] src) {
        this.add(0, src.length, src);
    }

    public void add(int offset, int len, T[] src) {
        if (this.size + len > this.elements.length) {
            int newCapacity = Math.max(this.calculateNewCapacity(this.elements.length), (this.size + len) * 2);
            this.elements = Arrays.copyOf(this.elements, newCapacity);
        }
        System.arraycopy(src, offset, this.elements, this.size, len);
        this.size += len;
    }

    public void copyTo(int offset, T[] dst) {
        System.arraycopy(this.elements, 0, dst, offset, this.size);
    }

    protected int calculateNewCapacity(int currentCapacity) {
        return currentCapacity * 10;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public T[] elements() {
        if (this.size < this.elements.length) {
            this.elements = Arrays.copyOf(this.elements, this.size);
        }
        return this.elements;
    }

    @Override
    public Iterator<T> iterator() {
        return IteratorToolkit.of(this.elements, 0, this.size);
    }
}

