/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.common.collection;

import com.oracle.jmc.common.collection.EntryHashMap;

public class MapToolkit {
    public static <K> EntryHashMap<K, LongEntry<K>> createLongMap(int initialCapacity, float loadFactor) {
        return new EntryHashMap<K, LongEntry<K>>(initialCapacity, loadFactor){

            @Override
            protected LongEntry<K> computeValue(K key) {
                return new LongEntry(key);
            }
        };
    }

    public static <K> EntryHashMap<K, IntEntry<K>> createIntMap(int initialCapacity, float loadFactor) {
        return new EntryHashMap<K, IntEntry<K>>(initialCapacity, loadFactor){

            @Override
            protected IntEntry<K> computeValue(K key) {
                return new IntEntry(key);
            }
        };
    }

    public static <K> EntryHashMap<K, DoubleEntry<K>> createDoubleMap(int initialCapacity, float loadFactor) {
        return new EntryHashMap<K, DoubleEntry<K>>(initialCapacity, loadFactor){

            @Override
            protected DoubleEntry<K> computeValue(K key) {
                return new DoubleEntry(key);
            }
        };
    }

    public static class DoubleEntry<K>
    extends EntryHashMap.Entry<K>
    implements Comparable<DoubleEntry<K>> {
        private double value = 0.0;

        private DoubleEntry(K key) {
            super(key);
        }

        @Override
        public int compareTo(DoubleEntry<K> o) {
            return Double.compare(this.value, o.value);
        }

        public boolean equals(Object obj) {
            if (obj instanceof DoubleEntry) {
                DoubleEntry o = (DoubleEntry)obj;
                return this.key.equals(o.key) && this.value == o.value;
            }
            return false;
        }

        public int hashCode() {
            return 13 * this.key.hashCode() + (int)Double.doubleToRawLongBits(this.value);
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }
    }

    public static class IntEntry<K>
    extends EntryHashMap.Entry<K>
    implements Comparable<IntEntry<K>> {
        private int value = 0;

        private IntEntry(K key) {
            super(key);
        }

        @Override
        public int compareTo(IntEntry<K> o) {
            return Integer.compare(this.value, o.value);
        }

        public boolean equals(Object obj) {
            if (obj instanceof IntEntry) {
                IntEntry o = (IntEntry)obj;
                return this.key.equals(o.key) && this.value == o.value;
            }
            return false;
        }

        public int hashCode() {
            return 17 * this.key.hashCode() + this.value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    public static class LongEntry<K>
    extends EntryHashMap.Entry<K>
    implements Comparable<LongEntry<K>> {
        private long value = 0L;

        private LongEntry(K key) {
            super(key);
        }

        @Override
        public int compareTo(LongEntry<K> o) {
            return Long.compare(this.value, o.value);
        }

        public boolean equals(Object obj) {
            if (obj instanceof LongEntry) {
                LongEntry o = (LongEntry)obj;
                return this.key.equals(o.key) && this.value == o.value;
            }
            return false;
        }

        public int hashCode() {
            return 19 * this.key.hashCode() + (int)this.value;
        }

        public long getValue() {
            return this.value;
        }

        public void setValue(long value) {
            this.value = value;
        }
    }

    public static class ObjectEntry<V>
    extends EntryHashMap.Entry<Object> {
        private V value = null;

        public ObjectEntry(Object key, V value) {
            super(key);
            this.value = value;
        }

        public V getValue() {
            return this.value;
        }

        public void setValue(V value) {
            this.value = value;
        }
    }
}

