/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.common.collection;

import com.oracle.jmc.common.collection.IteratorToolkit;
import java.util.Iterator;

public abstract class KeyInValueMap<K, V>
implements Iterable<V> {
    private Object[] values;
    private int size;
    private int capacity;
    private int threshold;
    private final float loadFactor;

    public KeyInValueMap(int initialCapacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.createTable(initialCapacity);
    }

    public V get(K key, boolean computeIfAbsent) {
        int idx = this.getIndex(this.hashKey(key));
        while (this.values[idx] != null) {
            V e = this.getValue(idx);
            if (this.isKeyFor(key, e)) {
                return e;
            }
            idx = (idx + 1) % this.capacity;
        }
        if (computeIfAbsent) {
            V entry = this.computeValue(key);
            this.values[idx] = entry;
            ++this.size;
            if (this.size > this.threshold) {
                this.rehash();
            }
            return entry;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    @Override
    public Iterator<V> iterator() {
        return IteratorToolkit.skipNulls(IteratorToolkit.of(this.values));
    }

    private void createTable(int newCapacity) {
        this.capacity = newCapacity | 1;
        this.threshold = (int)((float)this.capacity * this.loadFactor);
        this.values = new Object[this.capacity];
    }

    private V getValue(int index) {
        return (V)this.values[index];
    }

    private void rehash() {
        Object[] oldEntries = this.values;
        this.createTable(this.capacity * 2);
        Object[] objectArray = oldEntries;
        int n = oldEntries.length;
        int n2 = 0;
        while (n2 < n) {
            Object oldEntry = objectArray[n2];
            if (oldEntry != null) {
                Object e = oldEntry;
                int idx = this.getIndex(this.hashFromValue(e));
                while (this.values[idx] != null) {
                    idx = (idx + 1) % this.capacity;
                }
                this.values[idx] = oldEntry;
            }
            ++n2;
        }
    }

    private int getIndex(int hash) {
        return (hash & Integer.MAX_VALUE) % this.capacity;
    }

    protected abstract boolean isKeyFor(K var1, V var2);

    protected abstract V computeValue(K var1);

    protected int hashKey(K key) {
        return key.hashCode();
    }

    protected abstract int hashFromValue(V var1);
}

