/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.common.collection;

import com.oracle.jmc.common.IPredicate;
import com.oracle.jmc.common.collection.AbstractIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class IteratorToolkit {
    public static <T> List<T> toList(Iterator<T> itr, int sizeHint) {
        ArrayList<T> list = new ArrayList<T>(sizeHint);
        while (itr.hasNext()) {
            list.add(itr.next());
        }
        return list;
    }

    public static <T> Iterator<T> skipNulls(Iterator<T> itr) {
        return IteratorToolkit.filter(itr, new IPredicate<T>(){

            @Override
            public boolean evaluate(T o) {
                return o != null;
            }
        });
    }

    public static <T> Iterator<T> filter(final Iterator<T> itr, final IPredicate<? super T> filter) {
        return new AbstractIterator<T>(){

            @Override
            protected T findNext() {
                while (itr.hasNext()) {
                    Object object = itr.next();
                    if (!filter.evaluate(object)) continue;
                    return object;
                }
                return this.NO_MORE_ELEMENTS;
            }
        };
    }

    public static <T> Iterator<T> of(T[] elements) {
        return IteratorToolkit.of(elements, 0, elements.length);
    }

    public static <T> Iterator<T> of(final T[] elements, int offset, final int len) {
        if (offset < 0 || offset > len || len > elements.length) {
            throw new IllegalArgumentException("Cannnot contruct iterator offset=" + offset + " len=" + len + " elements.length=" + elements.length);
        }
        return new Iterator<T>(offset){
            private int index;
            {
                this.index = n;
            }

            @Override
            public boolean hasNext() {
                return this.index != len;
            }

            @Override
            public T next() {
                try {
                    return elements[this.index++];
                }
                catch (IndexOutOfBoundsException e) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Iterator doesn't support removal.");
            }
        };
    }
}

