/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.triggers.internal;

import com.oracle.jmc.common.util.XmlToolkit;
import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.triggers.TriggerRule;
import com.oracle.jmc.rjmx.triggers.internal.INotificationFactory;
import com.oracle.jmc.rjmx.triggers.internal.NotificationRuleBag;
import com.oracle.jmc.rjmx.triggers.internal.RegistryEntry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NotificationRegistry {
    private static final Logger LOGGER = Logger.getLogger("com.oracle.jmc.rjmx.triggers");
    private static final String XML_ROOT_ELEMENT = "triggers";
    private static final String XML_ELEMENT_NOTIFICATION_RULES = "notification_rules";
    public static final String XML_RULE_COMPONENT_NAME = "notification_rule";
    public static final String XML_RULE_ELEMENT_NOTIFICATION_RULE_LINK = "notification_rule_link";
    public static final String XML_RULE_ELEMENT_RULE_NAME = "rule_name";
    public static final String XML_RULE_ELEMENT_RULE_PATH = "rule_path";
    public static final String XML_RULE_ELEMENT_RULE_ID = "rule_id";
    public static final String DEFAULT_RULE_NAME = "<new rule>";
    private INotificationFactory m_factory;
    private final List<RegistryEntry> m_availableConstraints = new LinkedList<RegistryEntry>();
    private final List<RegistryEntry> m_availableActions = new LinkedList<RegistryEntry>();
    private final Map<Class<?>, RegistryEntry> m_classToRegisterEntryMap = new HashMap();
    private final Set<TriggerRule> m_availableRules = new HashSet<TriggerRule>();
    protected HashMap<String, NotificationRuleBag> ruleBagMap = new HashMap();

    public void unregisterRule(TriggerRule rule, String serverGuid) {
        this.getRuleBagForUID(serverGuid).removeRule(rule);
    }

    public Collection<TriggerRule> getRegisteredRules(String uid) {
        return this.getRuleBagForUID(uid).getAllRegisteredRules();
    }

    public boolean registerRule(TriggerRule rule, String serverGuid) {
        return this.getRuleBagForUID(serverGuid).addRule(rule);
    }

    private NotificationRuleBag getRuleBagForUID(String uid) {
        NotificationRuleBag ruleBag = this.ruleBagMap.get(uid);
        if (ruleBag == null) {
            ruleBag = new NotificationRuleBag(uid);
            this.ruleBagMap.put(uid, ruleBag);
        }
        return ruleBag;
    }

    public List<RegistryEntry> getAvailableConstraints() {
        return this.m_availableConstraints;
    }

    public void registerConstraint(RegistryEntry constraintEntry) {
        this.m_availableConstraints.add(constraintEntry);
        this.m_classToRegisterEntryMap.put(constraintEntry.getRegisteredClass(), constraintEntry);
    }

    public void registerAction(RegistryEntry actionEntry) {
        this.m_availableActions.add(actionEntry);
        this.m_classToRegisterEntryMap.put(actionEntry.getRegisteredClass(), actionEntry);
    }

    public List<RegistryEntry> getAvailableActions() {
        return this.m_availableActions;
    }

    public synchronized RegistryEntry getEntryForClass(Class<?> myClass) {
        return this.m_classToRegisterEntryMap.get(myClass);
    }

    public Collection<TriggerRule> getAvailableRules() {
        return this.m_availableRules;
    }

    public void addNotificationRule(TriggerRule rule) {
        if (!this.isNameAvailable(rule.getName())) {
            throw new IllegalArgumentException();
        }
        this.m_availableRules.add(rule);
    }

    public void performCriticalRuleChange(TriggerRule rule, Runnable runnable) {
        ArrayList<NotificationRuleBag> bags = new ArrayList<NotificationRuleBag>();
        for (NotificationRuleBag bag : this.ruleBagMap.values()) {
            if (!bag.removeRule(rule)) continue;
            bags.add(bag);
        }
        runnable.run();
        for (NotificationRuleBag bag : bags) {
            bag.addRule(rule);
        }
    }

    public void removeNotificationRule(TriggerRule rule) {
        for (NotificationRuleBag bag : this.ruleBagMap.values()) {
            bag.removeRule(rule);
        }
        this.m_availableRules.remove(rule);
    }

    public boolean isNameAvailable(String name) {
        return this.getRuleByName(name) == null;
    }

    private TriggerRule getRuleByName(String ruleName) {
        for (TriggerRule rule : this.m_availableRules) {
            if (!rule.getName().equals(ruleName)) continue;
            return rule;
        }
        return null;
    }

    public Document exportToXml(Collection<TriggerRule> selected, boolean exportLinks) throws IOException {
        Document doc = XmlToolkit.createNewDocument((String)XML_ROOT_ELEMENT);
        Element repoRoot = doc.getDocumentElement();
        Element rulez = XmlToolkit.createElement((Element)repoRoot, (String)XML_ELEMENT_NOTIFICATION_RULES);
        for (TriggerRule rule : this.getAvailableRules()) {
            if (selected != null && !selected.contains(rule)) continue;
            rule.exportToXml(rulez);
        }
        if (exportLinks) {
            for (String uid : this.ruleBagMap.keySet()) {
                for (TriggerRule rule : this.getRegisteredRules(uid)) {
                    Element ruleLink = XmlToolkit.createElement((Element)repoRoot, (String)XML_RULE_ELEMENT_NOTIFICATION_RULE_LINK);
                    XmlToolkit.setSetting((Element)ruleLink, (String)XML_RULE_ELEMENT_RULE_ID, (String)uid);
                    XmlToolkit.setSetting((Element)ruleLink, (String)XML_RULE_ELEMENT_RULE_NAME, (String)rule.getName());
                }
            }
        }
        return doc;
    }

    public List<TriggerRule> importFromXML(Element node) throws IOException {
        if (!node.getTagName().equals(XML_ROOT_ELEMENT)) {
            throw new IOException();
        }
        Element rules = XmlToolkit.getOrCreateElement((Element)node, (String)XML_ELEMENT_NOTIFICATION_RULES);
        ArrayList<TriggerRule> badRules = new ArrayList<TriggerRule>();
        List ruleList = XmlToolkit.getChildElementsByTag((Node)rules, (String)XML_RULE_COMPONENT_NAME);
        for (Element ruleElem : ruleList) {
            TriggerRule rule = TriggerRule.buildFromXml(ruleElem, this.getFactory());
            if (rule.isComplete()) {
                if (!this.isNameAvailable(rule.getName())) {
                    badRules.add(rule);
                    continue;
                }
                this.addNotificationRule(rule);
                continue;
            }
            badRules.add(rule);
        }
        List ruleLinks = XmlToolkit.getChildElementsByTag((Node)node, (String)XML_RULE_ELEMENT_NOTIFICATION_RULE_LINK);
        for (Element ruleLink : ruleLinks) {
            String uid = XmlToolkit.getSetting((Element)ruleLink, (String)XML_RULE_ELEMENT_RULE_ID, null);
            if (uid == null) {
                LOGGER.log(Level.WARNING, "Could not find the UID for connection descriptor associated with the rule. Skipping rule.");
                continue;
            }
            String ruleName = XmlToolkit.getSetting((Element)ruleLink, (String)XML_RULE_ELEMENT_RULE_NAME, null);
            TriggerRule rule = this.getRuleByName(ruleName);
            if (rule == null) continue;
            this.getRuleBagForUID(uid).addRule(rule);
        }
        return badRules;
    }

    public void activateTriggersFor(IConnectionHandle connectionHandle) {
        this.getRuleBagForUID(connectionHandle.getServerDescriptor().getGUID()).activate(connectionHandle);
    }

    public void deactivateTriggersFor(String serverGuid) {
        this.getRuleBagForUID(serverGuid).deactivate();
    }

    public INotificationFactory getFactory() {
        return this.m_factory;
    }

    public void setFactory(INotificationFactory factory) {
        this.m_factory = factory;
    }
}

