/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.triggers.fields.internal;

import com.oracle.jmc.rjmx.triggers.fields.internal.Field;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;

public final class TimeField
extends Field {
    public TimeField(String id, String label, String defaultValue, String description) throws Exception {
        super(id, label, defaultValue, description);
    }

    protected DateFormat getFormat() {
        return DateFormat.getTimeInstance(3);
    }

    @Override
    protected String parsedValue(String value) throws Exception {
        ParsePosition pos = new ParsePosition(0);
        value = value.trim();
        String parsed = this.getFormat().format(this.getFormat().parse(value, pos));
        if (pos.getIndex() < value.length()) {
            return null;
        }
        return parsed;
    }

    @Override
    public Date getDateTime() {
        try {
            return this.getFormat().parse(this.getValue());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public int getType() {
        return 16;
    }

    @Override
    void initDefaultValue(String defaultValue) {
        if (!this.setValue(defaultValue)) {
            this.setValue(this.getFormat().format(new Date()));
        }
    }
}

