/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.triggers.fields.internal;

import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.ITypedQuantity;
import com.oracle.jmc.common.unit.KindOfQuantity;
import com.oracle.jmc.common.unit.QuantityConversionException;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.rjmx.triggers.fields.internal.Field;

public class QuantityField
extends Field {
    private KindOfQuantity<?> kind;
    private IQuantity min;
    private IQuantity max;

    public QuantityField(String id, String label, String defaultValue, String description) throws Exception {
        super(id, label, defaultValue, description);
    }

    @Override
    public int getType() {
        return 256;
    }

    @Override
    void initDefaultValue(String defaultValue) {
        if (!this.setValue(defaultValue)) {
            this.setValue(this.getKind().getDefaultUnit().quantity(0L).interactiveFormat());
        }
    }

    @Override
    String parsedValue(String value) throws Exception {
        ITypedQuantity quantity = this.kind.parseInteractive(value);
        if (!(this.min != null && this.min.compareTo((Object)quantity) > 0 || this.max != null && this.max.compareTo((Object)quantity) < 0)) {
            return quantity.interactiveFormat();
        }
        return null;
    }

    @Override
    public IQuantity getQuantity() {
        try {
            return this.kind.parseInteractive(this.getValue());
        }
        catch (QuantityConversionException e) {
            return null;
        }
    }

    public KindOfQuantity<?> getKind() {
        if (this.kind == null) {
            return UnitLookup.NUMBER;
        }
        return this.kind;
    }

    public void initKind(KindOfQuantity<?> kind, String defaultValue, IQuantity min, IQuantity max) {
        if (!this.getKind().equals(kind)) {
            this.setValue(null);
        }
        this.kind = kind;
        this.min = min;
        this.max = max;
        this.initDefaultValue(defaultValue);
        this.initDefaultPreferenceValue();
        this.updateListener();
    }

    public void setKind(KindOfQuantity<?> kind) {
        this.kind = kind;
    }
}

