/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.triggers.fields.internal;

import com.oracle.jmc.common.util.XmlToolkit;
import com.oracle.jmc.core.security.SecurityException;
import com.oracle.jmc.core.security.SecurityManagerFactory;
import com.oracle.jmc.rjmx.RJMXPlugin;
import com.oracle.jmc.rjmx.triggers.fields.internal.Field;
import java.util.logging.Level;
import org.w3c.dom.Element;

public final class PasswordField
extends Field {
    public PasswordField(String id, String label, String defaultValue, String description) throws Exception {
        super(id, label, defaultValue, description);
    }

    @Override
    public void initializeFromXml(Element node) {
        this.putValueAndUpdateListener(XmlToolkit.getSetting((Element)node, (String)this.getId(), (String)""));
    }

    @Override
    String parsedValue(String password) throws SecurityException {
        return password;
    }

    @Override
    protected void putValue(String newValue) {
        String newPasswordKey = this.createPasswordKey(newValue);
        this.releasePassword();
        super.putValue(newPasswordKey);
    }

    private String createPasswordKey(String password) {
        String key = "";
        if (!this.isEmptyPassword(password)) {
            try {
                key = SecurityManagerFactory.getSecurityManager().store(new String[]{password});
            }
            catch (SecurityException e) {
                RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not store password for field " + this.getId() + '!', e);
                throw new RuntimeException(e);
            }
        }
        return key;
    }

    @Override
    protected boolean equalsValue(String value) {
        String currentKey = this.getValue();
        if (this.isEmptyPassword(value)) {
            return this.isEmptyPassword(currentKey);
        }
        return value.equals(this.lookupPassword(currentKey));
    }

    private String lookupPassword(String key) {
        String password = "";
        try {
            if (!this.isEmptyPassword(key)) {
                password = ((String[])SecurityManagerFactory.getSecurityManager().get(key))[0];
            }
        }
        catch (SecurityException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not retrieve password for key " + key + " and field " + this.getId() + '!', e);
            throw new RuntimeException(e);
        }
        return password;
    }

    private boolean isEmptyPassword(String password) {
        return password == null || password.length() == 0;
    }

    @Override
    public String getPassword() {
        return this.lookupPassword(this.getValue());
    }

    @Override
    public int getType() {
        return 128;
    }

    @Override
    void initDefaultValue(String defaultValue) {
        this.setValue(defaultValue);
    }

    @Override
    public void initDefaultPreferenceValue() {
        String prefDefaultKey;
        if (this.getId() != null && (prefDefaultKey = RJMXPlugin.getDefault().getRJMXPreferences().get(this.getId(), null)) != null && prefDefaultKey.trim().length() != 0) {
            this.putValueAndUpdateListener(prefDefaultKey);
        }
    }

    private void putValueAndUpdateListener(String prefDefaultKey) {
        super.putValue(prefDefaultKey);
        this.updateListener();
    }

    private void releasePassword() {
        String key = this.getValue();
        if (!this.isEmptyPassword(key)) {
            try {
                String prefDefaultKey = null;
                if (this.getId() != null) {
                    prefDefaultKey = RJMXPlugin.getDefault().getRJMXPreferences().get(this.getId(), null);
                }
                if (prefDefaultKey == null || !prefDefaultKey.equals(key)) {
                    SecurityManagerFactory.getSecurityManager().withdraw(key);
                }
                super.putValue("");
            }
            catch (SecurityException e) {
                RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not release password for field " + this.getId() + " on dispose!", e);
            }
        }
    }
}

