/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.triggers.fields.internal;

import com.oracle.jmc.rjmx.triggers.fields.internal.Field;

public final class IntegerField
extends Field {
    private int m_min;
    private int m_max;

    public IntegerField(String id, String label, String defaultValue, String description, String min, String max) throws Exception {
        super(id, label, defaultValue, description);
        this.m_min = this.getLimit(min, Integer.MIN_VALUE);
        this.m_max = this.getLimit(max, Integer.MAX_VALUE);
        if (this.m_min > this.getInteger()) {
            this.m_min = Integer.MIN_VALUE;
        }
        if (this.m_max < this.getInteger()) {
            this.m_max = Integer.MAX_VALUE;
        }
    }

    @Override
    void initDefaultValue(String defaultValue) {
        this.m_min = Integer.MIN_VALUE;
        this.m_max = Integer.MAX_VALUE;
        if (!this.setValue(defaultValue)) {
            this.setValue(Integer.toString(0));
        }
    }

    @Override
    String parsedValue(String value) {
        int v = Integer.parseInt(value);
        if (v >= this.m_min && v <= this.m_max) {
            return Integer.toString(v);
        }
        return null;
    }

    @Override
    public Integer getInteger() {
        return Integer.valueOf(this.getValue());
    }

    @Override
    public int getType() {
        return 1;
    }

    int getLimit(String limit, int defaultValue) {
        try {
            return Integer.parseInt(limit);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }
}

