/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.triggers.actions.internal;

import com.oracle.jmc.core.MCFile;
import com.oracle.jmc.core.idesupport.IDESupportToolkit;
import com.oracle.jmc.rjmx.triggers.TriggerAction;
import com.oracle.jmc.rjmx.triggers.TriggerEvent;
import com.oracle.jmc.rjmx.triggers.actions.internal.Messages;
import com.oracle.jmc.rjmx.triggers.internal.NotificationToolkit;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import org.eclipse.osgi.util.NLS;

public class TriggerActionLogToFile
extends TriggerAction {
    @Override
    public void handleNotificationEvent(TriggerEvent e) {
        String fileName = this.getSetting("filename").getFileName();
        MCFile file = IDESupportToolkit.createFileResource((String)fileName);
        ByteArrayInputStream stream = new ByteArrayInputStream(this.getString(e).getBytes(StandardCharsets.UTF_8));
        String jobName = NLS.bind((String)Messages.TriggerActionLogToFile_JOBNAME, (Object)file.getPath());
        IDESupportToolkit.writeAsJob((String)jobName, (MCFile)file, (InputStream)stream, (boolean)true);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    private String getString(TriggerEvent e) {
        StringWriter sw = new StringWriter();
        sw.append(Messages.TriggerActionSystemOut_HEADER);
        sw.append(NotificationToolkit.prettyPrint(e));
        sw.append(Messages.TriggerActionSystemOut_FOOTER);
        return sw.toString();
    }
}

