/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.triggers;

import com.oracle.jmc.common.IDescribable;
import com.oracle.jmc.common.util.XmlToolkit;
import com.oracle.jmc.rjmx.RJMXPlugin;
import com.oracle.jmc.rjmx.triggers.ITriggerAction;
import com.oracle.jmc.rjmx.triggers.TriggerConstraintHolder;
import com.oracle.jmc.rjmx.triggers.internal.INotificationFactory;
import com.oracle.jmc.rjmx.triggers.internal.NotificationToolkit;
import com.oracle.jmc.rjmx.triggers.internal.NotificationTrigger;
import java.util.logging.Level;
import org.w3c.dom.Element;

public final class TriggerRule
implements Comparable<Object>,
IDescribable {
    private static final String DEFAULT_RULE_PATH = "<new group>";
    private static final String XML_ELEMENT_ACTION_CLASS = "notification_action_class";
    private static final String XML_ELEMENT_DESCRIPTION = "description";
    private static final String XML_ACTION_TAG = "notification_action";
    private static final String XML_CONSTRAINT_TAG = "constraint";
    private static final String XML_TRIGGER_TAG = "trigger";
    private static final String DEFAULT_DESCRIPTION = null;
    private volatile String m_name;
    private volatile NotificationTrigger m_trigger;
    private final TriggerConstraintHolder m_constraintHolder;
    private volatile ITriggerAction m_action;
    private String m_rulePath;
    private String m_description;

    public TriggerRule() {
        this("<new rule>", null, null);
    }

    public TriggerRule(String name, NotificationTrigger trigger, ITriggerAction action) {
        this(name, trigger, new TriggerConstraintHolder(), action);
    }

    public TriggerRule(String name, NotificationTrigger trigger, TriggerConstraintHolder constraintHolder, ITriggerAction action) {
        this(name, null, "Default Group", trigger, constraintHolder, action);
    }

    public TriggerRule(String name, String description, String rulePath, NotificationTrigger trigger, TriggerConstraintHolder constraintHolder, ITriggerAction action) {
        this.setName(name);
        this.setDescription(description);
        this.setRulePath(rulePath);
        this.setTrigger(trigger);
        this.m_constraintHolder = constraintHolder;
        this.setAction(action);
    }

    public ITriggerAction getAction() {
        return this.m_action;
    }

    public String getRulePath() {
        return this.m_rulePath;
    }

    public void setRulePath(String rulePath) {
        this.m_rulePath = rulePath;
    }

    public void setAction(ITriggerAction action) {
        this.m_action = action;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public NotificationTrigger getTrigger() {
        return this.m_trigger;
    }

    public void setTrigger(NotificationTrigger trigger) {
        this.m_trigger = trigger;
    }

    public TriggerConstraintHolder getConstraintHolder() {
        return this.m_constraintHolder;
    }

    public String toString() {
        return this.getName();
    }

    protected String getVerboseInformation() {
        StringBuffer sb = new StringBuffer();
        sb.append("----Notification rule----");
        sb.append("\nName: ");
        sb.append(this.getName());
        if (this.hasTrigger()) {
            sb.append("\nTrigger: ");
            sb.append(this.getTrigger().toString());
        } else {
            sb.append("\nNo trigger!");
        }
        if (this.hasConstraints()) {
            sb.append("\nConstraints:\n");
            sb.append(this.getConstraintHolder().toString());
        } else {
            sb.append("\nNoConstraints!\n");
        }
        if (this.hasAction()) {
            sb.append("Action: ");
            sb.append(this.getAction().toString());
        } else {
            sb.append("No action!");
        }
        return sb.toString();
    }

    public boolean hasConstraints() {
        return this.getConstraintHolder() != null && this.getConstraintHolder().getConstraintList().size() > 0;
    }

    public boolean hasTrigger() {
        return this.getTrigger() != null && NotificationToolkit.isComplete(this.getTrigger());
    }

    public boolean hasAction() {
        return this.getAction() != null;
    }

    @Override
    public int compareTo(Object o) {
        return this.toString().compareTo(o.toString());
    }

    public static TriggerRule buildFromXml(Element node, INotificationFactory factory) {
        String ruleName = XmlToolkit.getSetting((Element)node, (String)"rule_name", (String)"<new rule>");
        String rulePath = XmlToolkit.getSetting((Element)node, (String)"rule_path", (String)DEFAULT_RULE_PATH);
        String description = XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_DESCRIPTION, (String)DEFAULT_DESCRIPTION);
        NotificationTrigger trigger = factory.createTrigger();
        Element triggerNode = XmlToolkit.getOrCreateElement((Element)node, (String)XML_TRIGGER_TAG);
        trigger.initializeFromXml(triggerNode, factory);
        Element constraintsNode = XmlToolkit.getOrCreateElement((Element)node, (String)XML_CONSTRAINT_TAG);
        TriggerConstraintHolder constraintHolder = TriggerConstraintHolder.buildFromXml(constraintsNode, factory);
        Element actionNode = XmlToolkit.getOrCreateElement((Element)node, (String)XML_ACTION_TAG);
        String className = XmlToolkit.getSetting((Element)actionNode, (String)XML_ELEMENT_ACTION_CLASS, null);
        assert (className != null);
        ITriggerAction action = null;
        try {
            action = factory.createAction(className);
            action.initializeFromXml(actionNode);
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Error while initializing the rule " + ruleName, e);
            return new TriggerRule();
        }
        return new TriggerRule(ruleName, description, rulePath, trigger, constraintHolder, action);
    }

    public void exportToXml(Element parentNode) {
        Element ruleNode = XmlToolkit.createElement((Element)parentNode, (String)this.getComponentTag());
        XmlToolkit.setSetting((Element)ruleNode, (String)"rule_name", (String)this.getName());
        XmlToolkit.setSetting((Element)ruleNode, (String)"rule_path", (String)this.getRulePath());
        XmlToolkit.setSetting((Element)ruleNode, (String)XML_ELEMENT_DESCRIPTION, (String)this.getDescription());
        Element triggerNode = XmlToolkit.createElement((Element)ruleNode, (String)XML_TRIGGER_TAG);
        this.getTrigger().exportToXml(triggerNode);
        Element actionNode = XmlToolkit.createElement((Element)ruleNode, (String)XML_ACTION_TAG);
        XmlToolkit.setSetting((Element)actionNode, (String)XML_ELEMENT_ACTION_CLASS, (String)this.getAction().getClass().getName());
        this.getAction().exportToXml(actionNode);
        Element constraintsNode = XmlToolkit.createElement((Element)ruleNode, (String)XML_CONSTRAINT_TAG);
        this.m_constraintHolder.exportToXml(constraintsNode);
    }

    public boolean isComplete() {
        return this.hasTrigger() && NotificationToolkit.isComplete(this.getTrigger()) && this.hasAction();
    }

    private String getComponentTag() {
        return "notification_rule";
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public String getDescription() {
        return this.m_description;
    }

    public boolean isReady() {
        if (this.hasAction()) {
            return this.getAction().isReady();
        }
        return false;
    }
}

