/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.triggers;

import com.oracle.jmc.common.util.XmlToolkit;
import com.oracle.jmc.rjmx.RJMXPlugin;
import com.oracle.jmc.rjmx.triggers.ITriggerConstraint;
import com.oracle.jmc.rjmx.triggers.TriggerEvent;
import com.oracle.jmc.rjmx.triggers.internal.INotificationFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class TriggerConstraintHolder {
    private static final String XML_CONSTRAINT_TAG = "constraint";
    private static final String XML_ELEMENT_CONSTRAINT_CLASS = "constraint_class";
    private final List<ITriggerConstraint> m_constraintList = Collections.synchronizedList(new ArrayList(1));

    TriggerConstraintHolder() {
    }

    public List<ITriggerConstraint> getConstraintList() {
        return this.m_constraintList;
    }

    public void addConstraint(ITriggerConstraint constraint) {
        List<ITriggerConstraint> list = this.getConstraintList();
        if (!list.contains(constraint)) {
            this.getConstraintList().add(constraint);
        }
    }

    public void removeConstraint(ITriggerConstraint constraint) {
        this.getConstraintList().remove(constraint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValid(TriggerEvent e) {
        List<ITriggerConstraint> list;
        List<ITriggerConstraint> list2 = list = this.getConstraintList();
        synchronized (list2) {
            ITriggerConstraint constraint;
            Iterator<ITriggerConstraint> iter = this.getConstraintList().iterator();
            do {
                if (iter.hasNext()) continue;
                return true;
            } while ((constraint = iter.next()).isValid(e));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        List<ITriggerConstraint> list;
        StringBuffer buf = new StringBuffer();
        List<ITriggerConstraint> list2 = list = this.getConstraintList();
        synchronized (list2) {
            for (ITriggerConstraint constraint : this.getConstraintList()) {
                buf.append('\t');
                buf.append(constraint.getName());
                buf.append('\n');
            }
        }
        return buf.toString();
    }

    static TriggerConstraintHolder buildFromXml(Element node, INotificationFactory factory) {
        TriggerConstraintHolder holder = new TriggerConstraintHolder();
        NodeList constraints = node.getElementsByTagName(XML_CONSTRAINT_TAG);
        int i = 0;
        while (i < constraints.getLength()) {
            Element constraintNode = (Element)constraints.item(i);
            String className = XmlToolkit.getSetting((Element)constraintNode, (String)XML_ELEMENT_CONSTRAINT_CLASS, null);
            assert (className != null);
            ITriggerConstraint constraint = null;
            try {
                constraint = factory.createConstraint(className);
                constraint.initializeFromXml(constraintNode);
            }
            catch (Exception e) {
                RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Error instantiating NotificationConstraint.", e);
                return holder;
            }
            holder.addConstraint(constraint);
            ++i;
        }
        return holder;
    }

    void exportToXml(Element constraintsNode) {
        int i = 0;
        while (i < this.getConstraintList().size()) {
            ITriggerConstraint constraint = this.getConstraintList().get(i);
            Element constraintElement = XmlToolkit.createElement((Element)constraintsNode, (String)XML_CONSTRAINT_TAG);
            XmlToolkit.setSetting((Element)constraintElement, (String)XML_ELEMENT_CONSTRAINT_CLASS, (String)constraint.getClass().getName());
            constraint.exportToXml(constraintElement);
            ++i;
        }
    }
}

