/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.subscription.storage.internal;

import com.oracle.jmc.rjmx.internal.IDisposableService;
import com.oracle.jmc.rjmx.services.IAttributeStorage;
import com.oracle.jmc.rjmx.services.IAttributeStorageService;
import com.oracle.jmc.rjmx.subscription.ISubscriptionService;
import com.oracle.jmc.rjmx.subscription.MRI;
import com.oracle.jmc.rjmx.subscription.storage.internal.BufferingAttributeStorage;
import java.util.HashMap;
import java.util.Map;

public class DefaultAttributeStorageService
implements IAttributeStorageService,
IDisposableService {
    private final ISubscriptionService attributeSubscriptionService;
    private Map<MRI, BufferingAttributeStorage> activeStorages = new HashMap<MRI, BufferingAttributeStorage>();

    public DefaultAttributeStorageService(ISubscriptionService subscriptionService) {
        this.attributeSubscriptionService = subscriptionService;
    }

    @Override
    public synchronized IAttributeStorage getAttributeStorage(MRI mri) {
        if (this.activeStorages == null) {
            throw new IllegalStateException("Attribute storage service is disposed!");
        }
        BufferingAttributeStorage storage = this.activeStorages.get(mri);
        if (storage == null) {
            storage = new BufferingAttributeStorage(mri, this.attributeSubscriptionService);
            this.activeStorages.put(mri, storage);
        }
        return storage;
    }

    @Override
    public int getRetainedLength(MRI mri) {
        if (this.activeStorages == null) {
            throw new IllegalStateException("Attribute storage service is disposed!");
        }
        BufferingAttributeStorage storage = this.activeStorages.get(mri);
        if (storage != null) {
            return storage.getRetainedLength();
        }
        return 0;
    }

    @Override
    public synchronized void dispose() {
        for (BufferingAttributeStorage s : this.activeStorages.values()) {
            s.dispose();
        }
        this.activeStorages = null;
    }
}

