/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.subscription.internal;

import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.RJMXPlugin;
import com.oracle.jmc.rjmx.subscription.IMRIMetadataProvider;
import com.oracle.jmc.rjmx.subscription.IMRIMetadataService;
import com.oracle.jmc.rjmx.subscription.IMRISubscription;
import com.oracle.jmc.rjmx.subscription.ISubscriptionService;
import com.oracle.jmc.rjmx.subscription.IUpdatePolicy;
import com.oracle.jmc.rjmx.subscription.MRI;
import com.oracle.jmc.rjmx.subscription.internal.DefaultUpdatePolicy;
import com.oracle.jmc.rjmx.subscription.internal.OneShotUpdatePolicy;
import com.oracle.jmc.rjmx.subscription.internal.SimpleUpdatePolicy;
import java.util.logging.Level;

public final class UpdatePolicyToolkit {
    private static final String DEFAULT_UPDATE_INTERVAL = "defaultUpdateInterval";

    private UpdatePolicyToolkit() throws InstantiationException {
        throw new InstantiationException("Should not be instantiated!");
    }

    public static int getDefaultUpdateInterval() {
        return RJMXPlugin.getDefault().getRJMXPreferences().getInt("com.oracle.jmc.console.preferences.updateinterval", 1000);
    }

    public static void setUpdatePolicy(IConnectionHandle handle, MRI attributeDescriptor, IUpdatePolicy policy) {
        IMRIMetadataService metadataService = UpdatePolicyToolkit.getMetadataService(handle);
        if (metadataService == null) {
            return;
        }
        if (policy instanceof OneShotUpdatePolicy) {
            metadataService.setMetadata(attributeDescriptor, "UpdateTime", Integer.toString(0));
        } else if (policy instanceof SimpleUpdatePolicy) {
            SimpleUpdatePolicy s = (SimpleUpdatePolicy)policy;
            metadataService.setMetadata(attributeDescriptor, "UpdateTime", Integer.toString(s.getIntervalTime()));
        } else if (policy instanceof DefaultUpdatePolicy) {
            metadataService.setMetadata(attributeDescriptor, "UpdateTime", DEFAULT_UPDATE_INTERVAL);
        } else {
            throw new UnsupportedOperationException(policy.getClass() + "is not supported!");
        }
        UpdatePolicyToolkit.updateExistingSubscription(handle, attributeDescriptor);
    }

    private static void updateExistingSubscription(IConnectionHandle handle, MRI attributeDescriptor) {
        ISubscriptionService service = handle.getServiceOrNull(ISubscriptionService.class);
        if (service == null) {
            return;
        }
        IMRISubscription attributeSubscription = service.getMRISubscription(attributeDescriptor);
        if (attributeSubscription != null) {
            attributeSubscription.setUpdatePolicy(UpdatePolicyToolkit.getUpdatePolicy(handle, attributeDescriptor));
        }
    }

    public static IUpdatePolicy getUpdatePolicy(IConnectionHandle handle, MRI attributeDescriptor) {
        IMRIMetadataService metadataService = UpdatePolicyToolkit.getMetadataService(handle);
        if (metadataService != null) {
            return UpdatePolicyToolkit.getUpdatePolicy(metadataService.getMetadata(attributeDescriptor));
        }
        return DefaultUpdatePolicy.newPolicy();
    }

    public static IUpdatePolicy getUpdatePolicy(IMRIMetadataProvider info) {
        String update = (String)info.getMetadata("UpdateTime");
        if (update != null && !update.equals(DEFAULT_UPDATE_INTERVAL)) {
            try {
                int interval = Integer.parseInt(update);
                return interval == 0 ? OneShotUpdatePolicy.newPolicy() : SimpleUpdatePolicy.newPolicy(interval);
            }
            catch (NumberFormatException e) {
                RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Warning: The update_interval specified for attribute " + info.getMRI() + " is malformed. The default update time (" + Integer.toString(UpdatePolicyToolkit.getDefaultUpdateInterval()) + ") will be used instead.", e);
            }
        }
        return DefaultUpdatePolicy.newPolicy();
    }

    private static IMRIMetadataService getMetadataService(IConnectionHandle handle) {
        return handle.getServiceOrNull(IMRIMetadataService.class);
    }
}

