/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.subscription.internal;

import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.subscription.IMRIValueListener;
import com.oracle.jmc.rjmx.subscription.ISubscriptionService;
import com.oracle.jmc.rjmx.subscription.IUpdatePolicy;
import com.oracle.jmc.rjmx.subscription.MRI;
import com.oracle.jmc.rjmx.subscription.MRIValueEvent;
import com.oracle.jmc.rjmx.subscription.internal.AbstractAttributeSubscription;
import com.oracle.jmc.rjmx.subscription.internal.IIntervalUpdatePolicy;
import com.oracle.jmc.rjmx.subscription.internal.SimpleUpdatePolicy;
import com.oracle.jmc.rjmx.subscription.internal.UnavailableSubscriptionsRepository;
import com.oracle.jmc.rjmx.subscription.internal.UpdatePolicyToolkit;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.management.openmbean.CompositeData;

class UnavailableChildSubscriptions {
    private final ISubscriptionService m_subscriptionService;
    private final MRI m_parentMRI;
    private final IMRIValueListener m_parentValueListener;
    private final UnavailableSubscriptionsRepository m_repository;
    private final Set<AbstractAttributeSubscription> m_unavailableChildSubscriptions = new HashSet<AbstractAttributeSubscription>();

    public UnavailableChildSubscriptions(IConnectionHandle connectionHandle, MRI parentMRI, UnavailableSubscriptionsRepository repository) {
        this.m_subscriptionService = connectionHandle.getServiceOrNull(ISubscriptionService.class);
        this.m_parentMRI = parentMRI;
        this.m_repository = repository;
        this.m_parentValueListener = this.createValueListener();
        if (this.m_subscriptionService != null) {
            this.m_subscriptionService.addMRIValueListener(this.m_parentMRI, this.m_parentValueListener);
        }
    }

    public MRI getParentMRI() {
        return this.m_parentMRI;
    }

    public void dispose() {
        if (this.m_subscriptionService != null) {
            this.m_subscriptionService.removeMRIValueListener(this.m_parentValueListener);
        }
    }

    public boolean addChildSubscription(AbstractAttributeSubscription subscription) {
        if (!subscription.getMRIMetadata().getMRI().toString().startsWith(this.m_parentMRI.toString())) {
            throw new IllegalArgumentException("Child " + subscription.getMRIMetadata().getMRI() + " is not child of " + this.m_parentMRI);
        }
        boolean result = this.m_unavailableChildSubscriptions.add(subscription);
        this.adjustUpdatePolicy(subscription);
        return result;
    }

    private void adjustUpdatePolicy(AbstractAttributeSubscription subscription) {
        IUpdatePolicy updatePolicy = UpdatePolicyToolkit.getUpdatePolicy(subscription.getMRIMetadata());
        if (updatePolicy instanceof IIntervalUpdatePolicy && this.m_subscriptionService != null) {
            int updateInterval = ((IIntervalUpdatePolicy)updatePolicy).getIntervalTime();
            IUpdatePolicy parentPolicy = this.m_subscriptionService.getMRISubscription(this.m_parentMRI).getUpdatePolicy();
            if (parentPolicy instanceof IIntervalUpdatePolicy && updateInterval < ((IIntervalUpdatePolicy)parentPolicy).getIntervalTime()) {
                this.m_subscriptionService.getMRISubscription(this.m_parentMRI).setUpdatePolicy(SimpleUpdatePolicy.newPolicy(updateInterval));
            }
        }
    }

    public Collection<AbstractAttributeSubscription> getChildSubscriptions() {
        return this.m_unavailableChildSubscriptions;
    }

    private IMRIValueListener createValueListener() {
        return new IMRIValueListener(){

            @Override
            public void valueChanged(MRIValueEvent event) {
                if (event.getValue() instanceof CompositeData) {
                    UnavailableChildSubscriptions.this.dispose();
                    UnavailableChildSubscriptions.this.m_repository.movePossibleChildSubscriptions(UnavailableChildSubscriptions.this);
                }
            }
        };
    }

    public static boolean isCompositeChildSubscription(AbstractAttributeSubscription subscription) {
        MRI[] parents = subscription.getMRIMetadata().getMRI().getParentMRIs();
        return parents.length > 0;
    }

    public static MRI getParentMRI(AbstractAttributeSubscription subscription) {
        return subscription.getMRIMetadata().getMRI().getParentMRIs()[0];
    }
}

