/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.subscription.internal;

import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.subscription.IMRIMetadata;
import com.oracle.jmc.rjmx.subscription.IMRIMetadataService;
import com.oracle.jmc.rjmx.subscription.IMRITransformation;
import com.oracle.jmc.rjmx.subscription.IMRIValueListener;
import com.oracle.jmc.rjmx.subscription.ISubscriptionService;
import com.oracle.jmc.rjmx.subscription.MRI;
import com.oracle.jmc.rjmx.subscription.MRIValueEvent;
import com.oracle.jmc.rjmx.subscription.internal.AbstractAttributeSubscription;

public class TransformationSubscription
extends AbstractAttributeSubscription {
    private final IMRITransformation m_transformation;
    private final IMRIValueListener m_mriListener;
    private final ISubscriptionService m_subscriptionService;

    public TransformationSubscription(IConnectionHandle connectionHandle, IMRIMetadata info, IMRITransformation transformation) {
        super(connectionHandle, info);
        this.m_transformation = transformation;
        this.m_mriListener = this.createListener();
        this.m_subscriptionService = this.getConnectionHandle().getServiceOrDummy(ISubscriptionService.class);
        MRI[] mRIArray = transformation.getAttributes();
        int n = mRIArray.length;
        int n2 = 0;
        while (n2 < n) {
            MRI mri = mRIArray[n2];
            this.m_subscriptionService.addMRIValueListener(mri, this.m_mriListener);
            ++n2;
        }
        transformation.extendMetadata(connectionHandle.getServiceOrDummy(IMRIMetadataService.class), info);
    }

    private IMRIValueListener createListener() {
        return new IMRIValueListener(){

            @Override
            public void valueChanged(MRIValueEvent event) {
                Object eventValue = TransformationSubscription.this.m_transformation.createSubscriptionValue(event);
                if (eventValue != IMRITransformation.NO_VALUE) {
                    MRIValueEvent newEvent = new MRIValueEvent(TransformationSubscription.this.getMRIMetadata().getMRI(), event.getTimestamp(), eventValue);
                    TransformationSubscription.this.fireAttributeChange(newEvent);
                }
            }
        };
    }

    public void unregisterSubscription() {
        this.m_subscriptionService.removeMRIValueListener(this.m_mriListener);
    }
}

