/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.subscription.internal;

import com.oracle.jmc.common.util.TypeHandling;
import com.oracle.jmc.rjmx.RJMXPlugin;
import com.oracle.jmc.rjmx.subscription.IMBeanHelperService;
import com.oracle.jmc.rjmx.subscription.IMBeanServerChangeListener;
import com.oracle.jmc.rjmx.subscription.IMRIService;
import com.oracle.jmc.rjmx.subscription.IMRITransformation;
import com.oracle.jmc.rjmx.subscription.MRI;
import com.oracle.jmc.rjmx.subscription.internal.MRITransformationToolkit;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;

public final class MBeanMRIMetadataDB
implements IMRIService,
IMBeanServerChangeListener {
    private final IMBeanHelperService mbeanService;
    private final Map<ObjectName, Map<MRI, Map<String, Object>>> cachedMRIMetadata = new HashMap<ObjectName, Map<MRI, Map<String, Object>>>();
    private final Set<ObjectName> introspectedMBeans = new HashSet<ObjectName>();

    public MBeanMRIMetadataDB(IMBeanHelperService mbeanService) {
        this.mbeanService = mbeanService;
    }

    @Override
    public Set<MRI> getMRIs() {
        HashSet<MRI> allMRIOnServer = new HashSet<MRI>();
        try {
            for (ObjectName mbean : this.mbeanService.getMBeanNames()) {
                allMRIOnServer.addAll(this.getMBeanData(mbean).keySet());
            }
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Unable to retrieve MBean names from server!", e);
        }
        return allMRIOnServer;
    }

    @Override
    public boolean isMRIAvailable(MRI mri) {
        if (mri.getType() == MRI.Type.TRANSFORMATION) {
            return this.isTransformationAvailable(mri);
        }
        return this.getMBeanData(mri.getObjectName()).keySet().contains(mri);
    }

    private boolean isTransformationAvailable(MRI mri) {
        IMRITransformation transformation = MRITransformationToolkit.createTransformation(mri);
        MRI[] mRIArray = transformation.getAttributes();
        int n = mRIArray.length;
        int n2 = 0;
        while (n2 < n) {
            MRI attribute = mRIArray[n2];
            if (!this.isMRIAvailable(attribute)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mbeanUnregistered(ObjectName mbean) {
        Map<ObjectName, Map<MRI, Map<String, Object>>> map = this.cachedMRIMetadata;
        synchronized (map) {
            this.introspectedMBeans.remove(mbean);
            this.cachedMRIMetadata.remove(mbean);
        }
    }

    @Override
    public void mbeanRegistered(ObjectName mbean) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<MRI, Map<String, Object>> getMBeanData(ObjectName mbean) {
        if (this.hasIntrospectedMBean(mbean)) {
            Map<ObjectName, Map<MRI, Map<String, Object>>> map = this.cachedMRIMetadata;
            synchronized (map) {
                return this.getNonNullMap(this.cachedMRIMetadata, mbean);
            }
        }
        return this.introspectMBean(mbean);
    }

    private boolean hasIntrospectedMBean(ObjectName mbean) {
        return this.introspectedMBeans.contains(mbean);
    }

    private <K, V, C> Map<V, C> getNonNullMap(Map<K, Map<V, C>> map, K key) {
        Map<V, C> keyMap = map.get(key);
        if (keyMap == null) {
            return Collections.emptyMap();
        }
        return keyMap;
    }

    private Map<MRI, Map<String, Object>> lookupMBeanMRIData(ObjectName mbean) {
        MBeanInfo info = this.lookupMBeanInfo(mbean);
        if (info != null) {
            HashMap<MRI, Map<String, Object>> mbeanMetadata = new HashMap<MRI, Map<String, Object>>();
            MBeanFeatureInfo[] mBeanFeatureInfoArray = info.getAttributes();
            int n = mBeanFeatureInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                MBeanAttributeInfo attribute = mBeanFeatureInfoArray[n2];
                if (attribute.getName() == null) {
                    RJMXPlugin.getDefault().getLogger().warning("Omitting attribute with name==null in MBean + " + mbean.toString());
                } else {
                    if (attribute.getType() == null) {
                        RJMXPlugin.getDefault().getLogger().warning("Found MBean attribute with invalid type for " + mbean + "/" + attribute.getName());
                    }
                    mbeanMetadata.put(new MRI(MRI.Type.ATTRIBUTE, mbean, attribute.getName()), this.createMetadata(attribute));
                }
                ++n2;
            }
            mBeanFeatureInfoArray = info.getNotifications();
            n = mBeanFeatureInfoArray.length;
            n2 = 0;
            while (n2 < n) {
                MBeanFeatureInfo notification = mBeanFeatureInfoArray[n2];
                String[] stringArray = ((MBeanNotificationInfo)notification).getNotifTypes();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String type = stringArray[n4];
                    mbeanMetadata.put(new MRI(MRI.Type.NOTIFICATION, mbean, type), this.createMetadata((MBeanNotificationInfo)notification, type));
                    ++n4;
                }
                ++n2;
            }
            return mbeanMetadata;
        }
        return null;
    }

    private MBeanInfo lookupMBeanInfo(ObjectName mbean) {
        try {
            return this.mbeanService.getMBeanInfo(mbean);
        }
        catch (InstanceNotFoundException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.INFO, "MBean " + mbean + " does not exist on the server");
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Unable to retrieve MBean information from server!", e);
        }
        return null;
    }

    private Map<String, Object> createMetadata(MBeanAttributeInfo attribute) {
        String typeName = attribute.getType();
        Object originalType = attribute.getDescriptor().getFieldValue("originalType");
        if (originalType instanceof String) {
            typeName = (String)originalType;
        }
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("DisplayName", attribute.getName());
        metadata.put("Description", attribute.getDescription());
        metadata.put("AttributeType", typeName);
        metadata.put("composite", this.isCompositeType(attribute.getType()));
        metadata.put("Readable", attribute.isReadable());
        metadata.put("Writable", attribute.isWritable());
        metadata.put("Descriptor", attribute.getDescriptor());
        return metadata;
    }

    private Map<String, Object> createMetadata(MBeanNotificationInfo notification, String type) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("DisplayName", type);
        metadata.put("Description", notification.getDescription());
        metadata.put("AttributeType", notification.getName());
        metadata.put("Descriptor", notification.getDescriptor());
        return metadata;
    }

    private boolean isCompositeType(String className) {
        if (className == null) {
            return false;
        }
        try {
            return CompositeData.class.isAssignableFrom(TypeHandling.getClassWithName((String)className));
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<MRI, Map<String, Object>> introspectMBean(ObjectName mbean) {
        HashMap<MRI, Map<String, Object>> cachedMBeanInfo;
        Map<ObjectName, Map<MRI, Map<String, Object>>> map = this.cachedMRIMetadata;
        synchronized (map) {
            Map<MRI, Map<String, Object>> mbeanMetadata = this.cachedMRIMetadata.get(mbean);
            if (mbeanMetadata == null && (mbeanMetadata = this.lookupMBeanMRIData(mbean)) == null) {
                return Collections.emptyMap();
            }
            cachedMBeanInfo = new HashMap<MRI, Map<String, Object>>(mbeanMetadata);
            boolean hasIntrospected = true;
            for (Map.Entry<MRI, Map<String, Object>> entry : mbeanMetadata.entrySet()) {
                CompositeType type = this.getCompositeType(entry.getValue());
                if (type == null && this.isComposite(entry.getValue())) {
                    CompositeData compositeData = this.getCompositeData(entry.getKey());
                    if (compositeData != null) {
                        type = compositeData.getCompositeType();
                    } else {
                        hasIntrospected = false;
                    }
                }
                if (type == null) continue;
                Object readable = entry.getValue().get("Readable");
                Object writable = entry.getValue().get("Writable");
                entry.getValue().put("composite", true);
                cachedMBeanInfo.putAll(this.introspectChildren(entry.getKey(), type, readable, writable));
            }
            this.cachedMRIMetadata.put(mbean, cachedMBeanInfo);
            if (hasIntrospected) {
                this.introspectedMBeans.add(mbean);
            }
        }
        return new HashMap<MRI, Map<String, Object>>(cachedMBeanInfo);
    }

    private boolean isComposite(Map<String, Object> metadata) {
        Object object = metadata.get("composite");
        if (object != null && object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    private CompositeType getCompositeType(Map<String, Object> metadata) {
        Object type;
        Object descriptor = metadata.get("Descriptor");
        if (descriptor instanceof Descriptor && (type = ((Descriptor)descriptor).getFieldValue("openType")) instanceof CompositeType) {
            return (CompositeType)type;
        }
        return null;
    }

    private CompositeData getCompositeData(MRI mri) {
        try {
            Object attributeValue = this.mbeanService.getAttributeValue(mri);
            if (attributeValue instanceof CompositeData) {
                return (CompositeData)attributeValue;
            }
            return null;
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not retrieve attribute: " + mri, e);
            return null;
        }
    }

    private Map<MRI, Map<String, Object>> introspectChildren(MRI parentMRI, CompositeType parentType, Object readable, Object writable) {
        HashMap<MRI, Map<String, Object>> children = new HashMap<MRI, Map<String, Object>>();
        for (String key : parentType.keySet()) {
            String childAttribute = String.valueOf(key);
            MRI childMRI = new MRI(parentMRI, childAttribute);
            HashMap<String, Object> childMetadata = new HashMap<String, Object>();
            children.put(childMRI, childMetadata);
            childMetadata.put("DisplayName", childAttribute);
            childMetadata.put("Description", parentType.getDescription(childAttribute));
            childMetadata.put("AttributeType", parentType.getType(childAttribute).getClassName());
            childMetadata.put("Readable", readable);
            childMetadata.put("Writable", writable);
            OpenType<?> childType = parentType.getType(childAttribute);
            if (!(childType instanceof CompositeType)) continue;
            childMetadata.put("composite", true);
            children.putAll(this.introspectChildren(childMRI, (CompositeType)childType, readable, writable));
        }
        return children;
    }
}

