/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.subscription.internal;

import com.oracle.jmc.rjmx.subscription.internal.AbstractPropertySyntheticAttribute;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;

public class LongDifferenceAttribute
extends AbstractPropertySyntheticAttribute {
    private static String MINUEND = "minuend";
    private static String SUBTRAHEND = "subtrahend";

    @Override
    public Object getValue(MBeanServerConnection connection) throws MBeanException, ReflectionException {
        Map<String, Object> values = this.getPropertyAttributes(connection, new String[]{MINUEND, SUBTRAHEND});
        return this.getMinuend(values) - this.getSubtrahend(values);
    }

    private long getMinuend(Map<String, Object> values) throws MBeanException {
        return this.getLong(values, MINUEND);
    }

    private long getSubtrahend(Map<String, Object> values) throws MBeanException {
        return this.getLong(values, SUBTRAHEND);
    }

    private long getLong(Map<String, Object> values, String key) throws MBeanException {
        if (!values.containsKey(key)) {
            try {
                throw new AttributeNotFoundException("Attribute " + key + " not found!");
            }
            catch (AttributeNotFoundException e) {
                throw new MBeanException(e);
            }
        }
        return ((Number)values.get(key)).longValue();
    }

    @Override
    public boolean hasResolvedDependencies(MBeanServerConnection connection) {
        return this.hasResolvedAttribute(connection, MINUEND) && this.hasResolvedAttribute(connection, SUBTRAHEND);
    }
}

