/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.subscription.internal;

import com.oracle.jmc.rjmx.subscription.internal.AbstractPropertySyntheticAttribute;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;

public class DivisionAttribute
extends AbstractPropertySyntheticAttribute {
    private static final String DIVIDEND = "dividend";
    private static final String DIVISOR = "divisor";
    private static final String FACTOR = "factor";

    @Override
    public Object getValue(MBeanServerConnection connection) throws MBeanException, ReflectionException {
        Map<String, Object> values = this.getPropertyAttributes(connection, new String[]{DIVIDEND, DIVISOR});
        return this.getDividend(values) / this.getDivisor(values) * this.getFactor();
    }

    private double getDividend(Map<String, Object> values) throws MBeanException {
        return this.getDouble(values, DIVIDEND);
    }

    private double getDivisor(Map<String, Object> values) throws MBeanException {
        return this.getDouble(values, DIVISOR);
    }

    private double getDouble(Map<String, Object> values, String key) throws MBeanException {
        if (!values.containsKey(key)) {
            try {
                throw new AttributeNotFoundException("Attribute " + key + " not found!");
            }
            catch (AttributeNotFoundException e) {
                throw new MBeanException(e);
            }
        }
        return ((Number)values.get(key)).doubleValue();
    }

    private double getFactor() {
        if (!this.hasFactor()) {
            return 1.0;
        }
        return ((Number)this.getProperty(FACTOR)).doubleValue();
    }

    private boolean hasFactor() {
        Object value = this.getProperty(FACTOR);
        return value != null && value instanceof Number;
    }

    @Override
    public boolean hasResolvedDependencies(MBeanServerConnection connection) {
        return this.hasResolvedAttribute(connection, DIVIDEND) && this.hasResolvedAttribute(connection, DIVISOR);
    }
}

