/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.subscription.internal;

import com.oracle.jmc.rjmx.ConnectionException;
import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.ServiceNotAvailableException;
import com.oracle.jmc.rjmx.subscription.IMBeanHelperService;
import com.oracle.jmc.rjmx.subscription.IMRIMetadata;
import com.oracle.jmc.rjmx.subscription.IMRISubscription;
import com.oracle.jmc.rjmx.subscription.MRI;
import com.oracle.jmc.rjmx.subscription.MRIValueEvent;
import com.oracle.jmc.rjmx.subscription.internal.AbstractAttributeSubscription;
import com.oracle.jmc.rjmx.subscription.internal.AttributeValueToolkit;
import com.oracle.jmc.rjmx.subscription.internal.DefaultSubscriptionDebugInformation;
import com.oracle.jmc.rjmx.subscription.internal.IMRISubscriptionDebugInformation;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;

public final class DefaultNotificationSubscriptionManager {
    private static final Logger LOGGER = Logger.getLogger("com.oracle.jmc.rjmx.subscription");
    private final IMBeanHelperService service;
    private final MBeanServerConnection mbeanServer;
    private volatile boolean collectDebugInfo = false;
    private Map<MRI, DefaultSubscriptionDebugInformation> subscriptionDebugInfo;
    private final Map<AbstractAttributeSubscription, NotificationHandler> registeredHandlers = Collections.synchronizedMap(new HashMap());

    public DefaultNotificationSubscriptionManager(IConnectionHandle handle) throws ConnectionException, ServiceNotAvailableException {
        this.mbeanServer = handle.getServiceOrThrow(MBeanServerConnection.class);
        this.service = handle.getServiceOrThrow(IMBeanHelperService.class);
        this.clearDebugInformation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        NotificationHandler[] handlers;
        Map<AbstractAttributeSubscription, NotificationHandler> map = this.registeredHandlers;
        synchronized (map) {
            Collection<NotificationHandler> handlersCol = this.registeredHandlers.values();
            handlers = handlersCol.toArray(new NotificationHandler[handlersCol.size()]);
            this.registeredHandlers.clear();
        }
        NotificationHandler[] notificationHandlerArray = handlers;
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            NotificationHandler handler = notificationHandlerArray[n2];
            handler.unregisterWithMBeanServer();
            ++n2;
        }
    }

    public void registerNotificationAttributeSubscription(AbstractAttributeSubscription attributeSubscription) {
        if (attributeSubscription.getMRIMetadata().getMRI().getType() != MRI.Type.NOTIFICATION) {
            throw new IllegalArgumentException("This subscription manager only handles notification based attributes that extends AbstractAttributeSubscription.");
        }
        NotificationHandler handler = new NotificationHandler(attributeSubscription);
        handler.registerWithMBeanServer();
        NotificationHandler oldHandler = this.registeredHandlers.put(attributeSubscription, handler);
        if (oldHandler != null) {
            oldHandler.unregisterWithMBeanServer();
        }
    }

    public void unregisterNotificationAttributeSubscription(IMRISubscription attributeSubscription) {
        NotificationHandler handler = this.registeredHandlers.remove(attributeSubscription);
        if (handler != null) {
            handler.unregisterWithMBeanServer();
        }
    }

    public void collectDebugInformation(boolean collect) {
        this.collectDebugInfo = collect;
    }

    public void clearDebugInformation() {
        this.subscriptionDebugInfo = new HashMap<MRI, DefaultSubscriptionDebugInformation>();
    }

    public Collection<? extends IMRISubscriptionDebugInformation> getDebugInformation() {
        return this.subscriptionDebugInfo.values();
    }

    private void recordConnected(MRI mri) {
        if (this.collectDebugInfo) {
            DefaultSubscriptionDebugInformation info = this.getDebugInformation(mri, IMRISubscriptionDebugInformation.SubscriptionState.SUBSCRIBED);
            ++info.m_connectionCount;
        }
    }

    private void recordDisconnected(MRI mri) {
        if (this.collectDebugInfo) {
            DefaultSubscriptionDebugInformation info = this.getDebugInformation(mri, IMRISubscriptionDebugInformation.SubscriptionState.UNSUBSCRIBED);
            ++info.m_disconnectionCount;
        }
    }

    private void recordEventRecieved(MRIValueEvent event) {
        if (this.collectDebugInfo) {
            DefaultSubscriptionDebugInformation info = this.getDebugInformation(event.getMRI(), IMRISubscriptionDebugInformation.SubscriptionState.SUBSCRIBED);
            ++info.m_eventCount;
            info.m_lastEvent = event;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultSubscriptionDebugInformation getDebugInformation(MRI attribute, IMRISubscriptionDebugInformation.SubscriptionState state) {
        Map<MRI, DefaultSubscriptionDebugInformation> map = this.subscriptionDebugInfo;
        synchronized (map) {
            DefaultSubscriptionDebugInformation info = this.subscriptionDebugInfo.get(attribute);
            if (info == null) {
                info = new DefaultSubscriptionDebugInformation(attribute, state);
                this.subscriptionDebugInfo.put(attribute, info);
            } else {
                info.m_state = state;
            }
            return info;
        }
    }

    private class NotificationHandler
    implements NotificationListener {
        private final AbstractAttributeSubscription m_subscription;
        private final NotificationFilterSupport m_filter;

        public NotificationHandler(AbstractAttributeSubscription subscription) {
            this.m_subscription = subscription;
            String type = AttributeValueToolkit.getAttributeName(subscription.getMRIMetadata().getMRI().getDataPath());
            this.m_filter = new NotificationFilterSupport();
            this.m_filter.enableType(type);
        }

        @Override
        public void handleNotification(Notification notification, Object callbackObj) {
            if (DefaultNotificationSubscriptionManager.this.registeredHandlers.isEmpty()) {
                return;
            }
            try {
                MRI mri = this.m_subscription.getMRIMetadata().getMRI();
                String dataPath = mri.getDataPath();
                Object value = AttributeValueToolkit.lookupValue(dataPath, notification.getUserData());
                MRIValueEvent event = new MRIValueEvent(mri, DefaultNotificationSubscriptionManager.this.service.getApproximateServerTime(System.currentTimeMillis()), value);
                DefaultNotificationSubscriptionManager.this.recordEventRecieved(event);
                this.m_subscription.storeAndFireEvent(event);
            }
            catch (AttributeNotFoundException e) {
                LOGGER.log(Level.WARNING, "Notification object doesn't match declared structure.", e);
            }
        }

        public void registerWithMBeanServer() {
            try {
                IMRIMetadata info = this.m_subscription.getMRIMetadata();
                LOGGER.log(Level.FINE, "Adding listener " + info);
                DefaultNotificationSubscriptionManager.this.mbeanServer.addNotificationListener(info.getMRI().getObjectName(), this, (NotificationFilter)this.m_filter, null);
                DefaultNotificationSubscriptionManager.this.recordConnected(info.getMRI());
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "Exception occured when registering notification handler.", e);
            }
            catch (JMException e) {
                LOGGER.log(Level.WARNING, "Exception occured when registering notification handler.", e);
            }
        }

        private void unregisterWithMBeanServer() {
            IMRIMetadata info = this.m_subscription.getMRIMetadata();
            try {
                DefaultNotificationSubscriptionManager.this.mbeanServer.removeNotificationListener(info.getMRI().getObjectName(), this, (NotificationFilter)this.m_filter, null);
            }
            catch (JMException e) {
                LOGGER.log(Level.FINEST, "Got exception whilst removing notification listener. It was most likely already removed by some other handler.", e);
            }
            catch (IOException e) {
                LOGGER.log(Level.FINER, "Got exception whilst shutting down notification listeners. We were probably disconnected too early!", e);
            }
            DefaultNotificationSubscriptionManager.this.recordDisconnected(info.getMRI());
        }
    }
}

