/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.subscription.internal;

import com.oracle.jmc.rjmx.ConnectionException;
import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.RJMXPlugin;
import com.oracle.jmc.rjmx.ServiceNotAvailableException;
import com.oracle.jmc.rjmx.internal.IDisposableService;
import com.oracle.jmc.rjmx.subscription.IMBeanHelperService;
import com.oracle.jmc.rjmx.subscription.IMBeanServerChangeListener;
import com.oracle.jmc.rjmx.subscription.IMRIMetadata;
import com.oracle.jmc.rjmx.subscription.IMRIMetadataService;
import com.oracle.jmc.rjmx.subscription.MRI;
import com.oracle.jmc.rjmx.subscription.internal.MRIMetadataWrapper;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.management.ObjectName;

public final class DefaultMRIMetadataService
extends Observable
implements IMRIMetadataService,
IDisposableService {
    private final Observer metadataObserver;
    private final IMBeanHelperService mbeanService;
    private final IMBeanServerChangeListener mbeanListener = new IMBeanServerChangeListener(){

        @Override
        public void mbeanUnregistered(ObjectName mbean) {
            DefaultMRIMetadataService.this.metadataObserver.update(null, mbean);
        }

        @Override
        public void mbeanRegistered(ObjectName mbean) {
            DefaultMRIMetadataService.this.metadataObserver.update(null, mbean);
        }
    };

    public DefaultMRIMetadataService(IConnectionHandle handle) throws ConnectionException, ServiceNotAvailableException {
        this.metadataObserver = this.createMetadataObserver();
        DefaultMRIMetadataService.getGlobalService().addObserver(this.metadataObserver);
        this.mbeanService = handle.getServiceOrThrow(IMBeanHelperService.class);
        this.mbeanService.addMBeanServerChangeListener(this.mbeanListener);
    }

    @Override
    public IMRIMetadata getMetadata(MRI mri) {
        return new MRIMetadataWrapper(mri, this);
    }

    @Override
    public Object getMetadata(MRI mri, String dataKey) {
        Object md = DefaultMRIMetadataService.getGlobalService().getMetadata(mri, dataKey);
        if (md != null) {
            return md;
        }
        Map<String, Object> mriMetadata = this.mbeanService.getMBeanMetadata(mri.getObjectName()).get(mri);
        return mriMetadata != null ? mriMetadata.get(dataKey) : null;
    }

    @Override
    public void setMetadata(MRI mri, String dataKey, String data) {
        DefaultMRIMetadataService.getGlobalService().setMetadata(mri, dataKey, data);
    }

    @Override
    public void dispose() {
        this.mbeanService.removeMBeanServerChangeListener(this.mbeanListener);
        DefaultMRIMetadataService.getGlobalService().deleteObserver(this.metadataObserver);
    }

    private static IMRIMetadataService getGlobalService() {
        return RJMXPlugin.getDefault().getService(IMRIMetadataService.class);
    }

    private Observer createMetadataObserver() {
        return new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                DefaultMRIMetadataService.this.setChanged();
                DefaultMRIMetadataService.this.notifyObservers(arg);
            }
        };
    }
}

