/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.subscription.internal;

import com.oracle.jmc.rjmx.ConnectionException;
import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.ServiceNotAvailableException;
import com.oracle.jmc.rjmx.services.IAttributeStorageService;
import com.oracle.jmc.rjmx.subscription.IMBeanHelperService;
import com.oracle.jmc.rjmx.subscription.IMRISubscription;
import com.oracle.jmc.rjmx.subscription.MRI;
import com.oracle.jmc.rjmx.subscription.MRIValueEvent;
import com.oracle.jmc.rjmx.subscription.internal.AbstractAttributeSubscription;
import com.oracle.jmc.rjmx.subscription.internal.AttributeExceptionEvent;
import com.oracle.jmc.rjmx.subscription.internal.AttributeReregisteredEvent;
import com.oracle.jmc.rjmx.subscription.internal.AttributeValueToolkit;
import com.oracle.jmc.rjmx.subscription.internal.ConnectionLostEvent;
import com.oracle.jmc.rjmx.subscription.internal.DefaultSubscriptionDebugInformation;
import com.oracle.jmc.rjmx.subscription.internal.IMRISubscriptionDebugInformation;
import com.oracle.jmc.rjmx.subscription.internal.InvoluntaryDisconnectException;
import com.oracle.jmc.rjmx.subscription.internal.UnavailableSubscriptionsRepository;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;

public class DefaultAttributeSubscriptionThread
extends Thread {
    private static final Logger LOGGER = Logger.getLogger("com.oracle.jmc.rjmx.subscription");
    private final IConnectionHandle connectionHandle;
    private IAttributeStorageService attributeStorageService;
    private final IMBeanHelperService helperService;
    private final MBeanServerConnection server;
    private final Map<MRI, AbstractAttributeSubscription> attributeSubscriptions = new HashMap<MRI, AbstractAttributeSubscription>();
    private final Map<IMRISubscription, SubscriptionStats> subscriptionStats = new HashMap<IMRISubscription, SubscriptionStats>();
    private volatile boolean isRunning = true;
    private long lastTimestamp;
    private static final long MAX_SLEEP_TIME = 2000L;
    private static final long MIN_SLEEP_TIME = 100L;
    private final Set<AbstractAttributeSubscription> recentlyAddedSubscriptions = new HashSet<AbstractAttributeSubscription>();
    private final Set<AbstractAttributeSubscription> recentlyRemovedSubscriptions = new HashSet<AbstractAttributeSubscription>();
    private final UnavailableSubscriptionsRepository unavailableSubscriptionsRepository;
    private boolean sendNulls;
    private volatile boolean collectDebugInfo = false;
    private Map<MRI, DefaultSubscriptionDebugInformation> subscriptionDebugInfo;

    public DefaultAttributeSubscriptionThread(IConnectionHandle connectionHandle) throws ConnectionException, ServiceNotAvailableException {
        super("RJMX Subscription thread on " + connectionHandle.getServerDescriptor().getDisplayName());
        this.connectionHandle = connectionHandle;
        this.helperService = connectionHandle.getServiceOrThrow(IMBeanHelperService.class);
        this.server = connectionHandle.getServiceOrThrow(MBeanServerConnection.class);
        this.unavailableSubscriptionsRepository = new UnavailableSubscriptionsRepository(connectionHandle);
        this.clearDebugInformation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.isRunning) {
            this.unregisterSubscriptionsQueuedForRemove();
            this.reregisterPreviouslyBadSubscriptions();
            this.registerSubscriptionsQueuedForAdd();
            long sleepTime = this.retrieveAndDispatchValues();
            try {
                DefaultAttributeSubscriptionThread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                this.isRunning = false;
            }
        }
        Set<AbstractAttributeSubscription> set = this.recentlyRemovedSubscriptions;
        synchronized (set) {
            this.recentlyRemovedSubscriptions.addAll(this.attributeSubscriptions.values());
            this.recentlyRemovedSubscriptions.addAll(this.unavailableSubscriptionsRepository.getAllSubscriptions());
            this.unavailableSubscriptionsRepository.dispose();
        }
        this.unregisterSubscriptionsQueuedForRemove();
    }

    private long retrieveAndDispatchValues() {
        if (this.attributeSubscriptions.isEmpty()) {
            return 100L;
        }
        long now = System.currentTimeMillis();
        long nextUpdate = Long.MAX_VALUE;
        ArrayList<MRI> normalAttributes = new ArrayList<MRI>();
        for (AbstractAttributeSubscription subscription : this.attributeSubscriptions.values()) {
            SubscriptionStats stats = this.subscriptionStats.get(subscription);
            long targetTime = subscription.getUpdatePolicy().getNextUpdate(stats.lastUpdate);
            if (targetTime <= now) {
                normalAttributes.add(subscription.getMRIMetadata().getMRI());
                stats.lastUpdate = now;
                targetTime = subscription.getUpdatePolicy().getNextUpdate(now);
            }
            nextUpdate = Math.min(nextUpdate, targetTime);
        }
        this.retrieveAndDispatchNormalAttributes(normalAttributes);
        return Math.max(100L, Math.min(nextUpdate - now, 2000L));
    }

    private void retrieveAndDispatchNormalAttributes(List<MRI> normalAttributes) {
        try {
            List<MRIValueEvent> attributeValues = this.sampleAttributes(normalAttributes);
            this.dispatchEvents(attributeValues);
            if (attributeValues.size() != normalAttributes.size()) {
                this.removeBadAttributes(normalAttributes, attributeValues);
            }
        }
        catch (InstanceNotFoundException e) {
            this.searchAndRemoveBadAttributes(normalAttributes);
        }
        catch (ReflectionException e) {
            this.searchAndRemoveBadAttributes(normalAttributes);
        }
        catch (InvoluntaryDisconnectException e) {
            LOGGER.warning("Subscription thread is terminating due to loss of connection!");
            this.dispatchConnectionLostEvents();
            this.shutdown();
        }
        catch (ConnectException e) {
            LOGGER.warning("Subscription thread is terminating due to loss of connection!");
            this.dispatchConnectionLostEvents();
            this.shutdown();
        }
        catch (IOException e) {
            this.searchAndRemoveBadAttributes(normalAttributes);
        }
        catch (RuntimeException e) {
            if (this.isRunning) {
                throw e;
            }
            LOGGER.fine("Failed to get attributes, probably since the subscription thread is terminating");
        }
    }

    private List<MRIValueEvent> sampleAttributes(Iterable<MRI> attributes) throws IOException, InstanceNotFoundException, ReflectionException {
        long before = System.currentTimeMillis();
        Map<MRI, Object> values = AttributeValueToolkit.getAttributes(this.server, attributes);
        long timestamp = this.helperService.getApproximateServerTime((System.currentTimeMillis() + before) / 2L);
        ArrayList<MRIValueEvent> results = new ArrayList<MRIValueEvent>();
        for (Map.Entry<MRI, Object> entry : values.entrySet()) {
            results.add(new MRIValueEvent(entry.getKey(), timestamp, entry.getValue()));
        }
        return results;
    }

    private void dispatchConnectionLostEvents() {
        for (AbstractAttributeSubscription subscription : this.attributeSubscriptions.values()) {
            ConnectionLostEvent event = new ConnectionLostEvent(subscription, System.currentTimeMillis());
            subscription.storeAndFireEvent(event);
        }
    }

    public IConnectionHandle getConnectionHandle() {
        return this.connectionHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAttributeSubscription(IMRISubscription subscription) {
        if (!(subscription instanceof AbstractAttributeSubscription)) {
            throw new IllegalArgumentException("This version of the subscription service can only handle AbstractAttributeSubscriptions.");
        }
        Set<AbstractAttributeSubscription> set = this.recentlyAddedSubscriptions;
        synchronized (set) {
            this.recentlyAddedSubscriptions.add((AbstractAttributeSubscription)subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSubscriptionsQueuedForAdd() {
        if (Thread.currentThread() != this) {
            LOGGER.warning("registerQueuedSubscriptions abused in DefaultAttributeSubscriptionThread!");
        }
        ArrayList<AbstractAttributeSubscription> recentlyAdded = new ArrayList<AbstractAttributeSubscription>();
        Set<AbstractAttributeSubscription> set = this.recentlyAddedSubscriptions;
        synchronized (set) {
            recentlyAdded.addAll(this.recentlyAddedSubscriptions);
            this.recentlyAddedSubscriptions.clear();
        }
        for (AbstractAttributeSubscription subscription : recentlyAdded) {
            this.registerSubscription(subscription);
        }
    }

    private void registerSubscription(AbstractAttributeSubscription subscription) {
        if (this.subscriptionStats.get(subscription) == null) {
            this.sendNull(subscription);
            this.attributeSubscriptions.put(subscription.getMRIMetadata().getMRI(), subscription);
            this.recordConnected(subscription.getMRIMetadata().getMRI());
            this.subscriptionStats.put(subscription, new SubscriptionStats());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterSubscriptionsQueuedForRemove() {
        if (Thread.currentThread() != this) {
            LOGGER.warning("unregisterQueuedSubscriptions abused in DefaultAttributeSubscriptionThread!");
        }
        ArrayList<AbstractAttributeSubscription> recentlyRemoved = new ArrayList<AbstractAttributeSubscription>();
        Set<AbstractAttributeSubscription> set = this.recentlyRemovedSubscriptions;
        synchronized (set) {
            if (this.recentlyRemovedSubscriptions.isEmpty()) {
                return;
            }
            recentlyRemoved.addAll(this.recentlyRemovedSubscriptions);
            this.recentlyRemovedSubscriptions.clear();
        }
        for (AbstractAttributeSubscription subscription : recentlyRemoved) {
            this.unregisterSubscription(subscription);
            this.recordDisconnected(subscription.getMRIMetadata().getMRI());
            this.unavailableSubscriptionsRepository.remove(subscription);
        }
    }

    private void unregisterSubscription(AbstractAttributeSubscription subscription) {
        if (this.subscriptionStats.get(subscription) != null) {
            this.attributeSubscriptions.remove(subscription.getMRIMetadata().getMRI());
            this.subscriptionStats.remove(subscription);
            this.sendNull(subscription);
        }
    }

    private void sendNull(AbstractAttributeSubscription subscription) {
        if (this.isSendNulls()) {
            if (this.getLastTimestamp() == 0L) {
                this.setLastTimestamp(this.helperService.getApproximateServerTime(System.currentTimeMillis()));
            }
            subscription.storeAndFireEvent(new MRIValueEvent(subscription.getMRIMetadata().getMRI(), this.getLastTimestamp(), null));
        }
    }

    private void reregisterPreviouslyBadSubscriptions() {
        for (AbstractAttributeSubscription subscription : this.unavailableSubscriptionsRepository.getBackoffedSubscriptions()) {
            if (!this.hasSubscriptionBecomeAvailable(subscription)) continue;
            this.recordSucceededReconnection(subscription.getMRIMetadata().getMRI());
            this.registerSubscription(subscription);
            this.unavailableSubscriptionsRepository.remove(subscription);
            subscription.fireAttributeChange(new AttributeReregisteredEvent(subscription, this.getLastTimestamp()));
        }
    }

    private boolean hasSubscriptionBecomeAvailable(AbstractAttributeSubscription subscription) {
        return this.getBadAttributeError(subscription.getMRIMetadata().getMRI()) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAttributeSubscription(IMRISubscription subscription) {
        if (!(subscription instanceof AbstractAttributeSubscription)) {
            throw new IllegalArgumentException("This version of the subscription service can only handle AbstractAttributeSubscriptions.");
        }
        Set<AbstractAttributeSubscription> set = this.recentlyRemovedSubscriptions;
        synchronized (set) {
            this.recentlyRemovedSubscriptions.add((AbstractAttributeSubscription)subscription);
        }
    }

    public void shutdown() {
        this.isRunning = false;
        this.interrupt();
    }

    private void searchAndRemoveBadAttributes(List<MRI> attributesToFetch) {
        for (MRI mri : attributesToFetch) {
            if (!this.getConnectionHandle().isConnected()) {
                return;
            }
            Exception e = this.getBadAttributeError(mri);
            if (e != null) {
                this.recordConnectionLost(mri);
                this.removeBadAttribute(mri, e);
                continue;
            }
            this.recordEventPolled(mri);
        }
    }

    private void removeBadAttributes(List<MRI> attributesToFetch, List<MRIValueEvent> returnedAttributeValues) {
        int missing = attributesToFetch.size() - returnedAttributeValues.size();
        for (MRI attributeToFetch : attributesToFetch) {
            boolean found = false;
            for (MRIValueEvent returnedAttributeValue : returnedAttributeValues) {
                if (!attributeToFetch.equals(returnedAttributeValue.getMRI())) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.recordConnectionLost(attributeToFetch);
            this.removeBadAttribute(attributeToFetch, null);
            if (--missing > 0) continue;
            return;
        }
    }

    private void logError(Exception e, MRI mri) {
        LOGGER.info("The attribute " + mri + " could not be found in the specified JVM, and has been removed from the subscription engine!");
    }

    private void removeBadAttribute(MRI mri, Exception e) {
        AbstractAttributeSubscription subscription = this.getSubscription(mri);
        this.unregisterSubscription(subscription);
        this.unavailableSubscriptionsRepository.add(subscription);
        subscription.fireAttributeChange(new AttributeExceptionEvent(subscription, this.getLastTimestamp(), e));
        this.logError(e, mri);
    }

    private AbstractAttributeSubscription getSubscription(MRI mri) {
        return this.attributeSubscriptions.get(mri);
    }

    private Exception getBadAttributeError(MRI mri) {
        try {
            this.recordTriedReconnection(mri);
            this.helperService.getAttributeValue(mri);
            return null;
        }
        catch (Exception e) {
            return e;
        }
    }

    private void dispatchEvents(List<MRIValueEvent> timestampedDataList) {
        for (MRIValueEvent event : timestampedDataList) {
            AbstractAttributeSubscription subscription = this.getSubscription(event.getMRI());
            this.setLastTimestamp(Math.max(event.getTimestamp(), this.getLastTimestamp()));
            this.recordEventRecieved(event);
            subscription.storeAndFireEvent(event);
        }
    }

    public boolean isAttributeUnavailable(MRI descriptor) {
        return this.unavailableSubscriptionsRepository.contains(descriptor);
    }

    public synchronized long getLastTimestamp() {
        return this.lastTimestamp;
    }

    public synchronized void setLastTimestamp(long timestamp) {
        this.lastTimestamp = timestamp;
    }

    public void setSendNulls(boolean sendNulls) {
        this.sendNulls = sendNulls;
    }

    public boolean isSendNulls() {
        return this.sendNulls;
    }

    public void collectDebugInformation(boolean collect) {
        this.collectDebugInfo = collect;
    }

    public void clearDebugInformation() {
        this.subscriptionDebugInfo = new HashMap<MRI, DefaultSubscriptionDebugInformation>();
    }

    public Collection<? extends IMRISubscriptionDebugInformation> getDebugInformation() {
        return this.subscriptionDebugInfo.values();
    }

    private void recordConnected(MRI mri) {
        if (this.collectDebugInfo) {
            DefaultSubscriptionDebugInformation info = this.getDebugInformation(mri, IMRISubscriptionDebugInformation.SubscriptionState.SUBSCRIBED);
            ++info.m_connectionCount;
        }
    }

    private void recordDisconnected(MRI mri) {
        if (this.collectDebugInfo) {
            DefaultSubscriptionDebugInformation info = this.getDebugInformation(mri, IMRISubscriptionDebugInformation.SubscriptionState.UNSUBSCRIBED);
            ++info.m_disconnectionCount;
        }
    }

    private void recordEventRecieved(MRIValueEvent event) {
        if (this.collectDebugInfo) {
            DefaultSubscriptionDebugInformation info = this.getDebugInformation(event.getMRI(), IMRISubscriptionDebugInformation.SubscriptionState.SUBSCRIBED);
            ++info.m_eventCount;
            info.m_lastEvent = event;
            info.m_retainedEventCount = this.getRetainedLength(event.getMRI());
        }
    }

    private int getRetainedLength(MRI mri) {
        if (this.attributeStorageService == null) {
            this.attributeStorageService = this.getConnectionHandle().getServiceOrNull(IAttributeStorageService.class);
        }
        if (this.attributeStorageService != null) {
            return this.attributeStorageService.getRetainedLength(mri);
        }
        return 0;
    }

    private void recordEventPolled(MRI mri) {
        if (this.collectDebugInfo) {
            DefaultSubscriptionDebugInformation info = this.getDebugInformation(mri, IMRISubscriptionDebugInformation.SubscriptionState.SUBSCRIBED);
            ++info.m_eventCount;
            info.m_retainedEventCount = this.getRetainedLength(mri);
        }
    }

    private void recordConnectionLost(MRI mri) {
        if (this.collectDebugInfo) {
            DefaultSubscriptionDebugInformation info = this.getDebugInformation(mri, IMRISubscriptionDebugInformation.SubscriptionState.LOST);
            ++info.m_connectionLostCount;
        }
    }

    private void recordTriedReconnection(MRI mri) {
        if (this.collectDebugInfo) {
            DefaultSubscriptionDebugInformation info = this.getDebugInformation(mri, IMRISubscriptionDebugInformation.SubscriptionState.LOST);
            ++info.m_triedReconnectionCount;
        }
    }

    private void recordSucceededReconnection(MRI mri) {
        if (this.collectDebugInfo) {
            DefaultSubscriptionDebugInformation info = this.getDebugInformation(mri, IMRISubscriptionDebugInformation.SubscriptionState.SUBSCRIBED);
            ++info.m_succeededReconnectionCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultSubscriptionDebugInformation getDebugInformation(MRI attribute, IMRISubscriptionDebugInformation.SubscriptionState state) {
        Map<MRI, DefaultSubscriptionDebugInformation> map = this.subscriptionDebugInfo;
        synchronized (map) {
            DefaultSubscriptionDebugInformation info = this.subscriptionDebugInfo.get(attribute);
            if (info == null) {
                info = new DefaultSubscriptionDebugInformation(attribute, state);
                this.subscriptionDebugInfo.put(attribute, info);
            } else {
                info.m_state = state;
            }
            return info;
        }
    }

    public static class SubscriptionStats {
        public long lastUpdate = Long.MIN_VALUE;
    }
}

