/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.subscription.internal;

import com.oracle.jmc.rjmx.IPropertySyntheticAttribute;
import com.oracle.jmc.rjmx.subscription.MRI;
import com.oracle.jmc.rjmx.subscription.internal.AbstractSyntheticAttribute;
import com.oracle.jmc.rjmx.subscription.internal.AttributeValueToolkit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;

public abstract class AbstractPropertySyntheticAttribute
extends AbstractSyntheticAttribute
implements IPropertySyntheticAttribute {
    private Map<String, Object> m_properties;

    @Override
    public void setProperties(Map<String, Object> values) {
        this.m_properties = values;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasResolvedAttribute(MBeanServerConnection connection, String key) {
        Object value = this.m_properties.get(key);
        if (value == null) {
            return false;
        }
        try {
            MRI attribute = MRI.createFromQualifiedName(value.toString());
            String attributeName = AttributeValueToolkit.getAttributeName(attribute.getDataPath());
            MBeanInfo info = connection.getMBeanInfo(attribute.getObjectName());
            MBeanAttributeInfo[] mBeanAttributeInfoArray = info.getAttributes();
            int n = mBeanAttributeInfoArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                MBeanAttributeInfo attributeInfo = mBeanAttributeInfoArray[n2];
                if (attributeInfo.getName().equals(attributeName)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void setValue(MBeanServerConnection connection, Object value) {
    }

    protected Map<String, Object> getPropertyAttributes(MBeanServerConnection connection, String[] keys) throws ReflectionException, MBeanException {
        Map<MRI, Object> values;
        HashMap<MRI, String> attributeKeyMap = new HashMap<MRI, String>();
        ArrayList<MRI> attributes = new ArrayList<MRI>();
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            MRI attribute = this.lookupAttribute(key);
            if (attribute != null) {
                attributeKeyMap.put(attribute, key);
                attributes.add(attribute);
            }
            ++n2;
        }
        try {
            values = AttributeValueToolkit.getAttributes(connection, attributes);
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanException(e);
        }
        catch (IOException e) {
            throw new MBeanException(e);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : values.entrySet()) {
            result.put((String)attributeKeyMap.get(entry.getKey()), entry.getValue());
        }
        return result;
    }

    private MRI lookupAttribute(String key) {
        Object value = this.getProperty(key);
        if (value == null) {
            return null;
        }
        return MRI.createFromQualifiedName(value.toString());
    }

    protected Object getProperty(String key) {
        return this.m_properties.get(key);
    }
}

