/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.services.internal;

import com.oracle.jmc.rjmx.ConnectionToolkit;
import com.oracle.jmc.rjmx.RJMXPlugin;
import com.oracle.jmc.rjmx.ServiceNotAvailableException;
import com.oracle.jmc.rjmx.services.IAttributeInfo;
import com.oracle.jmc.rjmx.services.IDiagnosticCommandService;
import com.oracle.jmc.rjmx.services.IOperation;
import com.oracle.jmc.rjmx.services.IllegalOperandException;
import com.oracle.jmc.rjmx.services.internal.AbstractOperation;
import com.oracle.jmc.rjmx.util.internal.SimpleAttributeInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class HotSpot24DiagnosticCommandService
implements IDiagnosticCommandService {
    private static final ObjectName DIAGNOSTIC_BEAN = ConnectionToolkit.createObjectName("com.sun.management:type=DiagnosticCommand");
    private static final String OPERATION_UPDATE = "update";
    private final MBeanServerConnection m_mbeanServer;
    private final Map<String, String> commandNameToOperation = new HashMap<String, String>();
    private Collection<DiagnosticCommand> operations;
    private static final String IMPACT = "dcmd.vmImpact";
    private static final String NAME = "dcmd.name";
    private static final String DESCRIPTION = "dcmd.description";
    private static final String ARGUMENTS = "dcmd.arguments";
    private static final String ARGUMENT_NAME = "dcmd.arg.name";
    private static final String ARGUMENT_DESCRIPTION = "dcmd.arg.description";
    private static final String ARGUMENT_MANDATORY = "dcmd.arg.isMandatory";
    private static final String ARGUMENT_TYPE = "dcmd.arg.type";
    private static final String ARGUMENT_OPTION = "dcmd.arg.isOption";
    private static final String ARGUMENT_MULITPLE = "dcmd.arg.isMultiple";

    private static List<DiagnosticCommandParameter> extractSignature(Descriptor args) {
        if (args != null) {
            String[] argNames = args.getFieldNames();
            ArrayList<DiagnosticCommandParameter> parameters = new ArrayList<DiagnosticCommandParameter>(argNames.length);
            String[] stringArray = argNames;
            int n = argNames.length;
            int n2 = 0;
            while (n2 < n) {
                String argName = stringArray[n2];
                Descriptor arg = (Descriptor)args.getFieldValue(argName);
                parameters.add(new DiagnosticCommandParameter(arg));
                ++n2;
            }
            return parameters;
        }
        return Collections.emptyList();
    }

    private static IOperation.OperationImpact extractImpact(Descriptor d) {
        String impact = d.getFieldValue(IMPACT).toString();
        if (impact.startsWith("Low")) {
            return IOperation.OperationImpact.IMPACT_LOW;
        }
        if (impact.startsWith("Medium")) {
            return IOperation.OperationImpact.IMPACT_MEDIUM;
        }
        if (impact.startsWith("High")) {
            return IOperation.OperationImpact.IMPACT_HIGH;
        }
        return IOperation.OperationImpact.IMPACT_UNKNOWN;
    }

    private static String extractType(Descriptor d) {
        boolean isMultiple = Boolean.parseBoolean(d.getFieldValue(ARGUMENT_MULITPLE).toString());
        String typeName = d.getFieldValue(ARGUMENT_TYPE).toString();
        if (isMultiple) {
            if (typeName.equals("STRING SET")) {
                return String[].class.getName();
            }
            return String.valueOf(typeName.toLowerCase().replace(' ', '_')) + '*';
        }
        if (typeName.equals("BOOLEAN")) {
            return Boolean.class.getName();
        }
        if (typeName.equals("STRING") || typeName.equals("NANOTIME") || typeName.equals("MEMORY SIZE")) {
            return String.class.getName();
        }
        if (typeName.equals("JLONG")) {
            return Long.class.getName();
        }
        return typeName.toLowerCase().replace(' ', '_');
    }

    private static String extractDescription(Descriptor d) {
        String desc = d.getFieldValue(ARGUMENT_DESCRIPTION).toString().trim().replaceAll("\\\\\"", "\"");
        return desc.length() > 0 ? desc : d.getFieldValue(ARGUMENT_NAME).toString().trim();
    }

    public HotSpot24DiagnosticCommandService(MBeanServerConnection server) throws ServiceNotAvailableException {
        this.m_mbeanServer = server;
        try {
            this.refreshOperations();
        }
        catch (Exception e) {
            throw new ServiceNotAvailableException("Unable to retrieve diagnostic commands!");
        }
    }

    public synchronized Collection<DiagnosticCommand> getOperations() throws Exception {
        this.refreshOperations();
        return this.operations;
    }

    private void refreshOperations() throws Exception {
        MBeanInfo info = this.m_mbeanServer.getMBeanInfo(DIAGNOSTIC_BEAN);
        this.operations = new ArrayList<DiagnosticCommand>(info.getOperations().length);
        this.commandNameToOperation.clear();
        MBeanOperationInfo[] mBeanOperationInfoArray = info.getOperations();
        int n = mBeanOperationInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            MBeanOperationInfo oper = mBeanOperationInfoArray[n2];
            if (!oper.getName().equals(OPERATION_UPDATE)) {
                Descriptor descriptor = oper.getDescriptor();
                DiagnosticCommand c = new DiagnosticCommand(descriptor, oper.getReturnType());
                this.operations.add(c);
                this.commandNameToOperation.put(c.getName(), oper.getName());
            }
            ++n2;
        }
    }

    @Override
    public String runCtrlBreakHandlerWithResult(String command) throws Exception {
        int index = command.indexOf(32);
        if (index > 0) {
            String operationName = command.substring(0, index);
            return this.findDiagnosticCommand(operationName).execute(this.splitArguments(command.substring(index + 1).trim()));
        }
        return this.findDiagnosticCommand(command).execute(null);
    }

    private String[] splitArguments(String commandArguments) {
        ArrayList<String> arguments = new ArrayList<String>();
        StringBuilder argument = new StringBuilder();
        boolean inCitation = false;
        char[] cArray = commandArguments.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (inCitation) {
                if (c == '\"') {
                    inCitation = false;
                }
                argument.append(c);
            } else if (Character.isWhitespace(c)) {
                if (argument.length() > 0) {
                    arguments.add(argument.toString());
                    argument = new StringBuilder();
                }
            } else {
                if (c == '\"') {
                    inCitation = true;
                }
                argument.append(c);
            }
            ++n2;
        }
        if (argument.length() > 0) {
            arguments.add(argument.toString());
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    private synchronized DiagnosticCommand findDiagnosticCommand(String operationName) throws Exception {
        for (DiagnosticCommand op : this.operations) {
            if (!op.getName().equals(operationName)) continue;
            return op;
        }
        throw new IllegalArgumentException("Unavailable diagnostic command " + operationName + '!');
    }

    private static class ArgumentBuilder {
        private final List<String> arguments = new ArrayList<String>();

        private ArgumentBuilder() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void appendArgument(Object value, DiagnosticCommandParameter parameterInfo) throws IllegalOperandException {
            if (parameterInfo.isMultiple) {
                if (!value.getClass().isArray()) throw new IllegalOperandException(parameterInfo);
                Object[] objectArray = (Object[])value;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    this.appendValue(o, parameterInfo);
                    ++n2;
                }
                return;
            } else {
                this.appendValue(value, parameterInfo);
            }
        }

        private void appendValue(Object value, DiagnosticCommandParameter parameterInfo) throws IllegalOperandException {
            String stringValue;
            StringBuilder sb = new StringBuilder();
            if (parameterInfo.isOption) {
                sb.append(parameterInfo.parameterName).append('=');
            }
            if ((stringValue = String.valueOf(value)).indexOf(34) >= 0) {
                throw new IllegalOperandException(parameterInfo);
            }
            if (stringValue.indexOf(32) >= 0) {
                sb.append('\"').append(stringValue).append('\"');
            } else {
                sb.append(stringValue);
            }
            this.arguments.add(sb.toString());
        }

        public String[] asArray() {
            return this.arguments.toArray(new String[this.arguments.size()]);
        }
    }

    private class DiagnosticCommand
    extends AbstractOperation<DiagnosticCommandParameter> {
        public DiagnosticCommand(Descriptor d, String returnType) {
            super(d.getFieldValue(HotSpot24DiagnosticCommandService.NAME).toString(), d.getFieldValue(HotSpot24DiagnosticCommandService.DESCRIPTION).toString(), returnType, HotSpot24DiagnosticCommandService.extractSignature((Descriptor)d.getFieldValue(HotSpot24DiagnosticCommandService.ARGUMENTS)), HotSpot24DiagnosticCommandService.extractImpact(d));
            RJMXPlugin.getDefault().getLogger().fine("DiagnosticCommand() " + this.getName() + ' ' + this.getReturnType() + ' ' + (Object)((Object)this.getImpact()));
        }

        @Override
        public Callable<?> getInvocator(Object ... argValues) throws IllegalOperandException {
            ArgumentBuilder ab = new ArgumentBuilder();
            List args = this.getSignature();
            int i = 0;
            while (i < args.size()) {
                if (i >= argValues.length || argValues[i] == null) {
                    if (((DiagnosticCommandParameter)args.get(i)).isRequired) {
                        IllegalOperandException ex = new IllegalOperandException((IAttributeInfo)args.get(i));
                        while (++i < args.size()) {
                            if (!((DiagnosticCommandParameter)args.get(i)).isRequired) continue;
                            ex.addInvalidValue((IAttributeInfo)args.get(i));
                        }
                        throw ex;
                    }
                } else {
                    ab.appendArgument(argValues[i], (DiagnosticCommandParameter)args.get(i));
                }
                ++i;
            }
            final String[] arguments = ab.asArray();
            return new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return DiagnosticCommand.this.execute(arguments);
                }

                public String toString() {
                    return String.valueOf(DiagnosticCommand.this.getName()) + ' ' + DiagnosticCommand.this.asString(arguments);
                }
            };
        }

        private String asString(String[] array) {
            StringBuilder sb = new StringBuilder();
            if (array != null) {
                int i = 0;
                while (i < array.length) {
                    sb.append(array[i]);
                    if (i + 1 < array.length) {
                        sb.append(' ');
                    }
                    ++i;
                }
            }
            return sb.toString();
        }

        private String execute(String[] arguments) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
            String operation = (String)HotSpot24DiagnosticCommandService.this.commandNameToOperation.get(this.getName());
            RJMXPlugin.getDefault().getLogger().fine("Running " + this.getName() + " |" + operation + '|' + this.asString(arguments) + '|');
            if (operation == null) {
                throw new RuntimeException("Unavailable diagnostic command " + this.getName() + '!');
            }
            if (this.getSignature().size() > 0) {
                return (String)HotSpot24DiagnosticCommandService.this.m_mbeanServer.invoke(DIAGNOSTIC_BEAN, operation, new Object[]{arguments}, new String[]{String[].class.getName()});
            }
            return (String)HotSpot24DiagnosticCommandService.this.m_mbeanServer.invoke(DIAGNOSTIC_BEAN, operation, new Object[0], new String[0]);
        }
    }

    private static class DiagnosticCommandParameter
    extends SimpleAttributeInfo {
        private final boolean isOption;
        private final boolean isMultiple;
        private final boolean isRequired;
        private final String parameterName;

        public DiagnosticCommandParameter(Descriptor d) {
            super(d.getFieldValue(HotSpot24DiagnosticCommandService.ARGUMENT_NAME).toString(), HotSpot24DiagnosticCommandService.extractType(d), HotSpot24DiagnosticCommandService.extractDescription(d));
            this.parameterName = d.getFieldValue(HotSpot24DiagnosticCommandService.ARGUMENT_NAME).toString();
            this.isOption = Boolean.parseBoolean(d.getFieldValue(HotSpot24DiagnosticCommandService.ARGUMENT_OPTION).toString());
            this.isMultiple = Boolean.parseBoolean(d.getFieldValue(HotSpot24DiagnosticCommandService.ARGUMENT_MULITPLE).toString());
            this.isRequired = Boolean.parseBoolean(d.getFieldValue(HotSpot24DiagnosticCommandService.ARGUMENT_MANDATORY).toString());
            RJMXPlugin.getDefault().getLogger().fine("DiagnosticCommandArg() " + this.getType() + ' ' + this.getName() + ' ' + this.getDescription() + (this.isRequired ? " isRequired" : "") + (this.isOption ? " isOption" : "") + (this.isMultiple ? " isMultiple" : ""));
        }
    }
}

