/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.services.internal;

import com.oracle.jmc.rjmx.ConnectionException;
import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.ServiceNotAvailableException;
import com.oracle.jmc.rjmx.services.ICommercialFeaturesService;
import com.oracle.jmc.rjmx.services.IDiagnosticCommandService;
import com.oracle.jmc.rjmx.services.internal.HotspotManagementToolkit;
import javax.management.MBeanServerConnection;

public class HotSpot23CommercialFeaturesService
implements ICommercialFeaturesService {
    private static final String VM_FLAG = "UnlockCommercialFeatures";
    private static final String UNLOCK_COMMAND = "VM.unlock_commercial_features";
    private final MBeanServerConnection server;
    private final IDiagnosticCommandService dcs;

    public HotSpot23CommercialFeaturesService(IConnectionHandle handle) throws ConnectionException, ServiceNotAvailableException {
        this.server = handle.getServiceOrThrow(MBeanServerConnection.class);
        this.dcs = handle.getServiceOrNull(IDiagnosticCommandService.class);
        try {
            HotspotManagementToolkit.getVMOption(this.server, VM_FLAG);
        }
        catch (Exception e) {
            throw new ServiceNotAvailableException("");
        }
    }

    @Override
    public boolean isCommercialFeaturesEnabled() {
        try {
            return ((String)HotspotManagementToolkit.getVMOption(this.server, VM_FLAG)).contains("true");
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void enableCommercialFeatures() throws Exception {
        if (this.dcs != null) {
            this.dcs.runCtrlBreakHandlerWithResult(UNLOCK_COMMAND);
        }
        if (!this.isCommercialFeaturesEnabled()) {
            HotspotManagementToolkit.setVMOption(this.server, VM_FLAG, "true");
        }
    }
}

