/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.servermodel.internal;

import com.oracle.jmc.common.IDescribable;
import com.oracle.jmc.rjmx.ConnectionDescriptorBuilder;
import com.oracle.jmc.rjmx.IConnectionDescriptor;
import com.oracle.jmc.rjmx.IServerDescriptor;
import com.oracle.jmc.rjmx.RJMXPlugin;
import com.oracle.jmc.rjmx.descriptorprovider.IDescriptorListener;
import com.oracle.jmc.rjmx.descriptorprovider.IDescriptorProvider;
import com.oracle.jmc.rjmx.servermodel.IServer;
import com.oracle.jmc.rjmx.servermodel.IServerModel;
import com.oracle.jmc.rjmx.servermodel.internal.DiscoveryInfo;
import com.oracle.jmc.rjmx.servermodel.internal.ModelPersistence;
import com.oracle.jmc.rjmx.servermodel.internal.Server;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.logging.Level;
import javax.management.remote.JMXServiceURL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.w3c.dom.Document;

public final class ServerModel
extends Observable
implements IServerModel {
    private static final String EXTENSIONPOINT_DESCRIPTORPROVIDER = "descriptorProvider";
    private final Map<String, Server> elements = new HashMap<String, Server>();
    private final IDescriptorListener descriptorListener = new IDescriptorListener(){

        @Override
        public void onDescriptorRemoved(String descriptorId) {
            Server removedEntry = ServerModel.this.doRemove(descriptorId);
            if (removedEntry != null) {
                removedEntry.getServerHandle().dispose(false);
                ServerModel.this.modelChanged(null);
            }
        }

        @Override
        public void onDescriptorDetected(IServerDescriptor sd, String path, JMXServiceURL url, IConnectionDescriptor cd, IDescribable provider) {
            cd = cd != null ? cd : new ConnectionDescriptorBuilder().url(url).build();
            ServerModel.this.insert(new Server(path, url, null, new DiscoveryInfo(provider), sd, cd));
        }
    };

    public ServerModel() {
        this.setUpDiscoveryListeners();
    }

    public synchronized boolean isEmpty() {
        return this.elements.size() > 0;
    }

    public synchronized Server[] elements() {
        Collection<Server> serverCollection = this.elements.values();
        Server[] servers = new Server[serverCollection.size()];
        Iterator<Server> it = serverCollection.iterator();
        int i = 0;
        while (i < servers.length) {
            servers[i] = it.next();
            ++i;
        }
        return servers;
    }

    public void remove(IServer ... servers) {
        IServer[] iServerArray = servers;
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            IServer is = iServerArray[n2];
            Server server = this.doRemove(is.getServerHandle().getServerDescriptor().getGUID());
            if (server != null) {
                server.getServerHandle().dispose(true);
            }
            ++n2;
        }
        this.modelChanged(null);
    }

    private synchronized Server doRemove(String guid) {
        return this.elements.remove(guid);
    }

    private synchronized Server doAdd(Server server) {
        return this.elements.put(server.getServerHandle().getServerDescriptor().getGUID(), server);
    }

    public void insert(Server ... servers) {
        Server[] serverArray = servers;
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            Server server = serverArray[n2];
            Server oldEntry = this.doAdd(server);
            if (oldEntry != server) {
                server.setObserver(this::modelChanged);
                if (oldEntry != null) {
                    oldEntry.getServerHandle().dispose(true);
                }
            }
            ++n2;
        }
        this.modelChanged(null);
    }

    void modelChanged(Server element) {
        this.setChanged();
        this.notifyObservers(element);
    }

    public Document exportServers(Server ... servers) throws Exception {
        if (servers.length == 0) {
            return ModelPersistence.export(false, this.elements());
        }
        return ModelPersistence.export(true, servers);
    }

    public void importServers(Document doc) throws IOException {
        this.insert(ModelPersistence.loadSettings(doc));
    }

    private void setUpDiscoveryListeners() {
        IConfigurationElement[] configs;
        IExtensionRegistry er = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = configs = er.getConfigurationElementsFor("com.oracle.jmc.rjmx", EXTENSIONPOINT_DESCRIPTORPROVIDER);
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            try {
                if (config.getName().equals("provider")) {
                    IDescriptorProvider provider = (IDescriptorProvider)config.createExecutableExtension("class");
                    provider.addDescriptorListener(this.descriptorListener);
                }
            }
            catch (CoreException e) {
                RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Failed to start up a IDescriptorProvider!", e);
            }
            ++n2;
        }
    }
}

