/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.persistence.internal;

import com.oracle.jmc.common.util.StringToolkit;
import com.oracle.jmc.rjmx.RJMXPlugin;
import com.oracle.jmc.rjmx.internal.IDisposableService;
import com.oracle.jmc.rjmx.persistence.internal.AttributeWriter;
import com.oracle.jmc.rjmx.preferences.PreferencesKeys;
import com.oracle.jmc.rjmx.services.IPersistenceService;
import com.oracle.jmc.rjmx.subscription.ISubscriptionService;
import com.oracle.jmc.rjmx.subscription.MRI;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class PersistenceWriter
implements IPersistenceService,
IDisposableService,
IEclipsePreferences.IPreferenceChangeListener {
    private final Map<MRI, AttributeWriter> attributes = new HashMap<MRI, AttributeWriter>();
    private final String uid;
    private boolean running;
    private final ISubscriptionService service;

    public PersistenceWriter(String uid, ISubscriptionService service) {
        this.service = service;
        this.uid = uid;
        RJMXPlugin.getDefault().getRJMXPreferences().addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.loadState();
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        block5: {
            block4: {
                if (!event.getKey().equals("rjmx.services.persistence.directory") || !(event.getNewValue() instanceof String)) break block4;
                File uidPersistenceDirectory = this.calculatePersistenceDirectory((String)event.getNewValue());
                for (AttributeWriter writer : this.attributes.values()) {
                    writer.setPersistenceDir(uidPersistenceDirectory);
                }
                break block5;
            }
            if (!event.getKey().equals("rjmx.services.persistence.log.rotation.limit") || !(event.getNewValue() instanceof String)) break block5;
            try {
                long maxFileSize = this.calculateMaxFileSize(Long.parseLong((String)event.getNewValue()));
                for (AttributeWriter writer : this.attributes.values()) {
                    writer.setMaxFileSize(maxFileSize);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void start() throws IOException {
        for (Map.Entry<MRI, AttributeWriter> e : this.attributes.entrySet()) {
            if (!e.getValue().isEnabled()) continue;
            e.getValue().start();
            this.service.addMRIValueListener(e.getKey(), e.getValue());
        }
        this.running = true;
    }

    @Override
    public synchronized void stop() {
        this.running = false;
        for (AttributeWriter writer : this.attributes.values()) {
            this.service.removeMRIValueListener(writer);
            writer.stop();
        }
    }

    @Override
    public synchronized void add(MRI mri) {
        AttributeWriter writer = this.getWriter(mri);
        writer.setEnabled(true);
        if (this.isRunning()) {
            writer.start();
            this.service.addMRIValueListener(mri, writer);
        }
    }

    @Override
    public synchronized void remove(MRI mri) {
        AttributeWriter e = this.getWriter(mri);
        e.stop();
        e.setEnabled(false);
        this.service.removeMRIValueListener(mri, e);
    }

    @Override
    public synchronized MRI[] getAttributes() {
        ArrayList<MRI> active = new ArrayList<MRI>();
        for (Map.Entry<MRI, AttributeWriter> e : this.attributes.entrySet()) {
            if (!e.getValue().isEnabled()) continue;
            active.add(e.getKey());
        }
        return active.toArray(new MRI[active.size()]);
    }

    @Override
    public synchronized boolean isRunning() {
        return this.running;
    }

    private AttributeWriter getWriter(MRI mri) {
        AttributeWriter writer = this.attributes.get(mri);
        if (writer == null) {
            File persistenceDirectory = this.calculatePersistenceDirectory(RJMXPlugin.getDefault().getRJMXPreferences().get("rjmx.services.persistence.directory", PreferencesKeys.DEFAULT_PERSISTENCE_DIRECTORY));
            long maxFileSize = this.calculateMaxFileSize(RJMXPlugin.getDefault().getRJMXPreferences().getLong("rjmx.services.persistence.log.rotation.limit", 100L));
            writer = new AttributeWriter(mri, persistenceDirectory, maxFileSize);
            this.attributes.put(mri, writer);
        }
        return writer;
    }

    private void storeState() {
        StringBuilder allAttributes = new StringBuilder();
        for (Map.Entry<MRI, AttributeWriter> e : this.attributes.entrySet()) {
            if (!e.getValue().isEnabled()) continue;
            if (allAttributes.length() > 0) {
                allAttributes.append("|");
            }
            allAttributes.append(e.getKey().getQualifiedName());
        }
        if (allAttributes.length() > 0) {
            RJMXPlugin.getDefault().getServerPreferences(this.uid).put(this.getClass().getName(), allAttributes.toString());
        } else {
            RJMXPlugin.getDefault().getServerPreferences(this.uid).remove(this.getClass().getName());
        }
    }

    private void loadState() {
        String state = RJMXPlugin.getDefault().getServerPreferences(this.uid).get(this.getClass().getName(), null);
        if (state != null) {
            String[] stringArray = state.split("\\|");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                this.add(MRI.createFromQualifiedName(line.trim()));
                ++n2;
            }
        } else {
            this.add(MRI.createFromQualifiedName("attribute://java.lang:type=OperatingSystem/ProcessCpuLoad"));
            this.add(MRI.createFromQualifiedName("attribute://java.lang:type=OperatingSystem/SystemCpuLoad"));
            this.add(MRI.createFromQualifiedName("attribute://java.lang:type=OperatingSystem/UsedPhysicalMemorySize"));
            this.add(MRI.createFromQualifiedName("attribute://java.lang:type=Threading/ThreadCount"));
            this.add(MRI.createFromQualifiedName("attribute://java.lang:type=Memory/HeapMemoryUsage/committed"));
            this.add(MRI.createFromQualifiedName("attribute://java.lang:type=Memory/HeapMemoryUsage/used"));
            this.add(MRI.createFromQualifiedName("attribute://java.lang:type=Memory/NonHeapMemoryUsage/committed"));
            this.add(MRI.createFromQualifiedName("attribute://java.lang:type=Memory/NonHeapMemoryUsage/used"));
        }
    }

    @Override
    public synchronized void dispose() {
        RJMXPlugin.getDefault().getRJMXPreferences().removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.stop();
        this.storeState();
    }

    private long calculateMaxFileSize(long preferenceValue) {
        return preferenceValue * 1024L;
    }

    private File calculatePersistenceDirectory(String preferenceValue) {
        File persistenceDirectory = new File(preferenceValue);
        return new File(persistenceDirectory, StringToolkit.encodeFilename((String)this.uid));
    }
}

