/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.persistence.internal;

import com.oracle.jmc.common.io.IOToolkit;
import com.oracle.jmc.common.util.StringToolkit;
import com.oracle.jmc.rjmx.RJMXPlugin;
import com.oracle.jmc.rjmx.persistence.internal.PersistenceFile;
import com.oracle.jmc.rjmx.persistence.internal.PersistenceStorage;
import com.oracle.jmc.rjmx.persistence.internal.PersistentMRIDataSeries;
import com.oracle.jmc.rjmx.preferences.PreferencesKeys;
import com.oracle.jmc.rjmx.services.IAttributeStorage;
import com.oracle.jmc.rjmx.services.IAttributeStorageService;
import com.oracle.jmc.rjmx.subscription.IMRIService;
import com.oracle.jmc.rjmx.subscription.MRI;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class PersistenceReader
implements IMRIService,
IAttributeStorageService {
    private final Map<MRI, PersistenceStorage> storages = new HashMap<MRI, PersistenceStorage>();

    public PersistenceReader(File directory, String uid) {
        File[] pFiles;
        if (directory == null) {
            directory = PersistenceReader.getPersistenceDirectoryPreference();
        }
        if (uid != null) {
            directory = new File(directory, StringToolkit.encodeFilename((String)uid));
        }
        if (directory.isDirectory() && (pFiles = directory.listFiles()) != null) {
            File[] fileArray = pFiles;
            int n = pFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File attributeDir = fileArray[n2];
                this.extractFromAttributeDir(attributeDir);
                ++n2;
            }
        }
    }

    private void extractFromAttributeDir(File attributeDir) {
        MRI mri;
        if (!attributeDir.isDirectory()) {
            return;
        }
        try {
            mri = MRI.createFromQualifiedName(URLDecoder.decode(attributeDir.getName(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not create MRI from directory name " + attributeDir.getName(), e);
            return;
        }
        ArrayList<PersistenceFile> files = new ArrayList<PersistenceFile>();
        File[] listFiles = attributeDir.listFiles(PersistenceFile.FILTER);
        if (listFiles != null) {
            File[] fileArray = listFiles;
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                try {
                    PersistenceFile pf = new PersistenceFile(f);
                    if (pf.eventCount > 0) {
                        files.add(pf);
                    }
                }
                catch (Exception e) {
                    RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not add file " + f.getPath(), e);
                }
                ++n2;
            }
        }
        Collections.sort(files, PersistenceFile.PERSISTENCE_FILE_START_COMPARATOR);
        ArrayList<Long> seriesStart = new ArrayList<Long>();
        DataInputStream seriesFileStream = null;
        File seriesFile = new File(attributeDir, "series.info");
        try {
            try {
                seriesFileStream = new DataInputStream(new BufferedInputStream(new FileInputStream(seriesFile)));
                while (seriesFileStream.available() > 0) {
                    seriesStart.add(seriesFileStream.readLong());
                }
            }
            catch (IOException e) {
                RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Error while reading persisted data from file " + seriesFile.getPath(), e);
                IOToolkit.closeSilently((Closeable)seriesFileStream);
                return;
            }
        }
        catch (Throwable e) {
            IOToolkit.closeSilently(seriesFileStream);
            throw e;
        }
        IOToolkit.closeSilently((Closeable)seriesFileStream);
        PersistenceStorage storage = new PersistenceStorage();
        if (seriesStart.isEmpty()) {
            storage.series.add(new PersistentMRIDataSeries(mri, files, Long.MIN_VALUE, Long.MAX_VALUE));
        } else {
            int i = 0;
            while (i < seriesStart.size()) {
                long seriesEnd = i + 1 < seriesStart.size() ? (Long)seriesStart.get(i + 1) : Long.MAX_VALUE;
                storage.series.add(new PersistentMRIDataSeries(mri, files, (Long)seriesStart.get(i), seriesEnd));
                ++i;
            }
        }
        this.storages.put(mri, storage);
    }

    private static File getPersistenceDirectoryPreference() {
        File persistenceDirectory = new File(RJMXPlugin.getDefault().getRJMXPreferences().get("rjmx.services.persistence.directory", PreferencesKeys.DEFAULT_PERSISTENCE_DIRECTORY));
        return persistenceDirectory;
    }

    @Override
    public Set<MRI> getMRIs() {
        return this.storages.keySet();
    }

    @Override
    public boolean isMRIAvailable(MRI mri) {
        return true;
    }

    @Override
    public IAttributeStorage getAttributeStorage(MRI attributeDescriptor) {
        return this.storages.get(attributeDescriptor);
    }

    @Override
    public int getRetainedLength(MRI attributeDescriptor) {
        return 0;
    }
}

