/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.persistence.internal;

import com.oracle.jmc.common.internal.xydata.ITimestampedData;
import com.oracle.jmc.rjmx.RJMXPlugin;
import com.oracle.jmc.rjmx.persistence.internal.PersistenceFile;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;

class FileIterator
implements Iterator<ITimestampedData> {
    int nextIndex;
    ITimestampedData[] currentFileData;
    Iterator<PersistenceFile> files;
    long min;
    long max;
    ITimestampedData next;

    FileIterator(Iterator<PersistenceFile> data, long min, long max) {
        this.files = data;
        this.min = min;
        this.max = max;
        if (max > min) {
            this.binarySearchFirst();
        }
    }

    private void binarySearchFirst() {
        if (this.findNextFile()) {
            int highBound = this.currentFileData.length - 1;
            while (highBound >= this.nextIndex) {
                int middleIndex = this.nextIndex + highBound >>> 1;
                long middleX = (Long)this.currentFileData[middleIndex].getX();
                if (middleX == this.min) {
                    this.nextIndex = middleIndex;
                    break;
                }
                if (middleX < this.min) {
                    this.nextIndex = middleIndex + 1;
                    continue;
                }
                highBound = middleIndex - 1;
            }
            this.readNext();
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public ITimestampedData next() {
        if (!this.hasNext()) {
            throw new IllegalStateException();
        }
        ITimestampedData tmp = this.next;
        if (this.currentFileData != null && this.nextIndex < this.currentFileData.length || this.findNextFile()) {
            this.readNext();
        } else {
            this.next = null;
        }
        return tmp;
    }

    private void readNext() {
        this.next = this.currentFileData[this.nextIndex++];
        this.next = (Long)this.next.getX() < this.max ? this.next : null;
    }

    private boolean findNextFile() {
        this.currentFileData = null;
        while (this.files.hasNext()) {
            PersistenceFile file = this.files.next();
            if (file.end < this.min) continue;
            if (file.start >= this.max) {
                return false;
            }
            try {
                this.currentFileData = file.getEvents(this.min, this.max);
                if (this.currentFileData.length <= 0) continue;
                this.nextIndex = 0;
                return true;
            }
            catch (IOException e) {
                RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not read events from file", e);
            }
        }
        return false;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

