/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.internal;

import com.oracle.jmc.rjmx.ConnectionException;
import com.oracle.jmc.rjmx.ConnectionToolkit;
import com.oracle.jmc.rjmx.messages.internal.Messages;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import javax.management.remote.JMXServiceURL;
import javax.naming.NameNotFoundException;
import javax.naming.NoInitialContextException;
import org.eclipse.osgi.util.NLS;

public class WrappedConnectionException
extends ConnectionException {
    private final JMXServiceURL url;
    private final String serverName;

    public WrappedConnectionException(String serverName, JMXServiceURL url, Exception cause) {
        super(cause.getMessage());
        this.initCause(cause);
        this.url = url;
        this.serverName = serverName;
    }

    @Override
    public String getLocalizedMessage() {
        String protocol;
        Throwable cause;
        Throwable rootCause = cause = this.getCause();
        while (rootCause.getCause() != null) {
            rootCause = rootCause.getCause();
        }
        String hostName = this.url != null ? ConnectionToolkit.getHostName(this.url) : Messages.ConnectionException_UNRESOLVED;
        String string = protocol = this.url != null ? this.url.getProtocol() : Messages.ConnectionException_UNRESOLVED;
        if (rootCause instanceof UnknownHostException) {
            return NLS.bind((String)Messages.ConnectionException_COULD_NOT_DETERMINE_IP_MSG, (Object)hostName);
        }
        if (rootCause instanceof NameNotFoundException) {
            return NLS.bind((String)Messages.ConnectionException_NAME_NOT_FOUND_MSG, (Object)this.serverName, (Object)this.url);
        }
        if (rootCause instanceof MalformedURLException) {
            return NLS.bind((String)Messages.ConnectionException_MALFORMED_URL_MSG, (Object)this.serverName, (Object)this.url);
        }
        if (rootCause instanceof NoInitialContextException) {
            return NLS.bind((String)Messages.ConnectionException_UNABLE_TO_CREATE_INITIAL_CONTEXT, (Object)this.serverName, (Object)this.url);
        }
        if (protocol.equals("msarmi")) {
            return NLS.bind((String)Messages.ConnectionException_MSARMI_CHECK_PASSWORD, (Object)this.serverName, (Object)this.url);
        }
        if (rootCause instanceof SecurityException || rootCause instanceof GeneralSecurityException) {
            return NLS.bind((String)Messages.ConnectionException_UNABLE_TO_RESOLVE_CREDENTIALS, (Object)this.serverName, (Object)rootCause.getLocalizedMessage());
        }
        if ("com.sun.tools.attach.AttachNotSupportedException".equals(rootCause.getClass().getName())) {
            return NLS.bind((String)Messages.ConnectionException_ATTACH_NOT_SUPPORTED, (Object)this.serverName, (Object)rootCause.getLocalizedMessage());
        }
        return NLS.bind((String)Messages.ConnectionException_COULD_NOT_CONNECT_MSG, (Object)this.serverName, (Object)this.url);
    }

    @Override
    public String toString() {
        return String.valueOf(ConnectionException.class.getName()) + " caused by " + this.getCause().toString();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        throw new IOException("You should not serialize instances of " + this.getClass().getName());
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        throw new IOException("You should not serialize instances of " + this.getClass().getName());
    }
}

