/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.internal;

import com.oracle.jmc.rjmx.RJMXPlugin;
import com.oracle.jmc.rjmx.internal.SyntheticNotificationEntry;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.RequiredModelMBean;

public class SyntheticNotificationMBean
extends RequiredModelMBean {
    public SyntheticNotificationMBean(SyntheticNotificationEntry[] entries) throws RuntimeOperationsException, MBeanException {
        this.initializeModelMBeanInfo(entries);
    }

    private void initializeModelMBeanInfo(SyntheticNotificationEntry[] entries) {
        try {
            this.setModelMBeanInfo(new ModelMBeanInfoSupport(this.getClass().getName(), "Synthetic notification.", null, null, null, this.createNotificationInfo(entries)));
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not setup synthetic notification MBean!", e);
        }
    }

    private ModelMBeanNotificationInfo[] createNotificationInfo(SyntheticNotificationEntry[] entries) {
        ArrayList<ModelMBeanNotificationInfo> list = new ArrayList<ModelMBeanNotificationInfo>();
        SyntheticNotificationEntry[] syntheticNotificationEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            SyntheticNotificationEntry entry = syntheticNotificationEntryArray[n2];
            ModelMBeanNotificationInfo notificationInfo = this.createNotificationInfo(entry);
            Descriptor descriptorCopy = notificationInfo.getDescriptor();
            descriptorCopy.setField("openType", entry.getNotification().getValueType());
            notificationInfo.setDescriptor(descriptorCopy);
            list.add(notificationInfo);
            ++n2;
        }
        return list.toArray(new ModelMBeanNotificationInfo[list.size()]);
    }

    private ModelMBeanNotificationInfo createNotificationInfo(SyntheticNotificationEntry entry) {
        return new ModelMBeanNotificationInfo(new String[]{entry.getNotificationDescriptor().getDataPath()}, Notification.class.getName(), entry.getDescription());
    }
}

