/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.internal;

import com.oracle.jmc.core.jvm.JVMDescriptor;
import com.oracle.jmc.rjmx.IServerHandle;
import com.oracle.jmc.rjmx.servermodel.IServer;

public class ServerToolkit {
    public static JVMDescriptor getJvmInfo(IServer server) {
        if (server != null) {
            return ServerToolkit.getJvmInfo(server.getServerHandle());
        }
        return null;
    }

    public static JVMDescriptor getJvmInfo(IServerHandle serverHandle) {
        if (serverHandle != null && serverHandle.getServerDescriptor() != null) {
            return serverHandle.getServerDescriptor().getJvmInfo();
        }
        return null;
    }

    public static boolean isAttachable(IServerHandle serverHandle) {
        JVMDescriptor jvmInfo = ServerToolkit.getJvmInfo(serverHandle);
        if (jvmInfo != null) {
            return jvmInfo.isAttachable();
        }
        return false;
    }

    public static boolean isUnconnectable(IServerHandle serverHandle) {
        JVMDescriptor jvmInfo = ServerToolkit.getJvmInfo(serverHandle);
        if (jvmInfo != null) {
            return jvmInfo.isUnconnectable();
        }
        return false;
    }

    public static Integer getPid(IServerHandle serverHandle) {
        JVMDescriptor jvmInfo = ServerToolkit.getJvmInfo(serverHandle);
        return jvmInfo == null ? null : jvmInfo.getPid();
    }

    public static String getJavaCommand(IServer server) {
        JVMDescriptor jvmInfo = ServerToolkit.getJvmInfo(server);
        if (jvmInfo != null) {
            return jvmInfo.getJavaCommand();
        }
        return null;
    }

    public static String getDisplayName(IServer server) {
        if (server != null) {
            return ServerToolkit.getDisplayName(server.getServerHandle());
        }
        return null;
    }

    public static String getDisplayName(IServerHandle serverHandle) {
        if (serverHandle != null && serverHandle.getServerDescriptor() != null) {
            return serverHandle.getServerDescriptor().getDisplayName();
        }
        return null;
    }

    public static String getJVMArguments(IServer server) {
        JVMDescriptor jvmInfo = ServerToolkit.getJvmInfo(server);
        if (jvmInfo != null) {
            return jvmInfo.getJVMArguments();
        }
        return null;
    }
}

