/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.internal;

import com.oracle.jmc.common.io.IOToolkit;
import com.oracle.jmc.rjmx.ConnectionException;
import com.oracle.jmc.rjmx.IConnectionDescriptor;
import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.IConnectionListener;
import com.oracle.jmc.rjmx.IServerDescriptor;
import com.oracle.jmc.rjmx.IServerHandle;
import com.oracle.jmc.rjmx.internal.DefaultConnectionHandle;
import com.oracle.jmc.rjmx.internal.RJMXConnection;
import com.oracle.jmc.rjmx.internal.ServerDescriptor;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ServerHandle
implements IServerHandle {
    private final List<DefaultConnectionHandle> connectionHandles = new ArrayList<DefaultConnectionHandle>();
    private final RJMXConnection connection;
    private final Runnable observer;
    private Boolean disposedGracefully;
    private final Runnable connectionListener = new Runnable(){

        @Override
        public void run() {
            ServerHandle.this.disconnect();
        }
    };
    private final IConnectionListener connectionHandleListener = new IConnectionListener(){

        @Override
        public void onConnectionChange(IConnectionHandle handle) {
            if (!handle.isConnected() && ServerHandle.this.removeConnectionHandle(handle)) {
                ServerHandle.this.nofifyObserver();
            }
        }
    };

    public ServerHandle(IConnectionDescriptor descriptor) {
        this(new ServerDescriptor(), descriptor, null);
    }

    public ServerHandle(IServerDescriptor server, IConnectionDescriptor descriptor, Runnable observer) {
        this.observer = observer;
        this.connection = new RJMXConnection(descriptor, server, this.connectionListener);
    }

    public IConnectionDescriptor getConnectionDescriptor() {
        return this.connection.getConnectionDescriptor();
    }

    @Override
    public IServerDescriptor getServerDescriptor() {
        return this.connection.getServerDescriptor();
    }

    public synchronized IConnectionHandle[] getConnectionHandles() {
        IConnectionHandle[] handles = new IConnectionHandle[this.connectionHandles.size()];
        Iterator<DefaultConnectionHandle> it = this.connectionHandles.iterator();
        int i = 0;
        while (i < handles.length) {
            handles[i] = it.next();
            ++i;
        }
        return handles;
    }

    @Override
    public IConnectionHandle connect(String usage) throws ConnectionException {
        IConnectionListener[] listeners = new IConnectionListener[]{this.connectionHandleListener};
        return this.doConnect(usage, listeners);
    }

    @Override
    public IConnectionHandle connect(String usage, IConnectionListener listener) throws ConnectionException {
        IConnectionListener[] listeners = new IConnectionListener[]{listener, this.connectionHandleListener};
        return this.doConnect(usage, listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IConnectionHandle doConnect(String usage, IConnectionListener[] listeners) throws ConnectionException {
        DefaultConnectionHandle newConnectionHandle;
        boolean performedConnect;
        ServerHandle serverHandle = this;
        synchronized (serverHandle) {
            if (this.isDisposed()) {
                throw new ConnectionException("Server handle is disposed");
            }
            performedConnect = this.connection.connect();
            newConnectionHandle = new DefaultConnectionHandle(this.connection, usage, listeners);
            this.connectionHandles.add(newConnectionHandle);
        }
        if (performedConnect) {
            this.nofifyObserver();
        }
        return newConnectionHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(boolean gracefully) {
        ServerHandle serverHandle = this;
        synchronized (serverHandle) {
            if (!this.isDisposed()) {
                this.disposedGracefully = gracefully;
            }
        }
        this.disconnect();
    }

    @Override
    public void dispose() {
        this.dispose(true);
    }

    private synchronized boolean isDisposed() {
        return this.disposedGracefully != null;
    }

    private synchronized boolean removeConnectionHandle(IConnectionHandle handle) {
        this.connectionHandles.remove(handle);
        if (this.connectionHandles.size() == 0) {
            this.connection.close();
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.disconnect();
    }

    private void disconnect() {
        IConnectionHandle[] iConnectionHandleArray = this.getConnectionHandles();
        int n = iConnectionHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionHandle handle = iConnectionHandleArray[n2];
            IOToolkit.closeSilently((Closeable)handle);
            ++n2;
        }
    }

    public String toString() {
        return this.connection.toString();
    }

    private void nofifyObserver() {
        if (this.observer != null) {
            this.observer.run();
        }
    }

    @Override
    public synchronized IServerHandle.State getState() {
        if (this.isDisposed()) {
            return this.disposedGracefully != false ? IServerHandle.State.DISPOSED : IServerHandle.State.FAILED;
        }
        return this.connection.isConnected() ? IServerHandle.State.CONNECTED : IServerHandle.State.DISCONNECTED;
    }

    protected void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
    }
}

