/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.internal;

import com.oracle.jmc.common.IStateful;
import com.oracle.jmc.common.util.StateToolkit;
import com.oracle.jmc.common.util.XmlToolkit;
import com.oracle.jmc.rjmx.RJMXPlugin;
import com.oracle.jmc.rjmx.servermodel.IServerModel;
import com.oracle.jmc.rjmx.servermodel.internal.Server;
import com.oracle.jmc.rjmx.servermodel.internal.ServerModel;
import com.oracle.jmc.rjmx.subscription.IMRIMetadataService;
import com.oracle.jmc.rjmx.subscription.internal.ExtensionMetadataProviderService;
import com.oracle.jmc.rjmx.subscription.internal.FileMRIMetadataDB;
import com.oracle.jmc.rjmx.triggers.extension.internal.TriggerFactory;
import com.oracle.jmc.rjmx.triggers.internal.NotificationRegistry;
import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.w3c.dom.Document;

public final class RJMXSingleton {
    private static final String PREFERENCE_ATTRIBUTE_METADATA_MANAGER = "AttributeMetadataManager";
    private static final String SERVER_MODEL_PREF = "server_model";
    private static final String TRIGGERS_MODEL_PREF = "triggers_model";
    private static final RJMXSingleton INSTANCE = new RJMXSingleton();
    private final FileMRIMetadataDB metadataManager = RJMXSingleton.buildMetadataManager();
    private final NotificationRegistry notificationModel = new NotificationRegistry();
    private final ServerModel serverModel = new ServerModel();

    private RJMXSingleton() {
        TriggerFactory tf = new TriggerFactory(this.notificationModel);
        tf.initializeFactory();
        this.notificationModel.setFactory(tf);
        this.initAllSettings();
        try {
            this.cleanServerPreferences();
        }
        catch (BackingStoreException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Failed to clean server preferences", e);
        }
    }

    private static FileMRIMetadataDB buildMetadataManager() {
        ExtensionMetadataProviderService subService = new ExtensionMetadataProviderService();
        String attributeMetadata = RJMXPlugin.getDefault().getRJMXPreferences().get(PREFERENCE_ATTRIBUTE_METADATA_MANAGER, null);
        if (attributeMetadata != null) {
            try {
                return FileMRIMetadataDB.buildFromState(StateToolkit.fromXMLString((String)attributeMetadata), subService);
            }
            catch (Exception e) {
                RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Failed to load stored attribute metadata", e);
            }
        }
        return FileMRIMetadataDB.buildDefault(subService);
    }

    private void initAllSettings() {
        try {
            String serverModelState = this.getRJMXPreferences().get(SERVER_MODEL_PREF, null);
            if (serverModelState != null) {
                this.serverModel.importServers(XmlToolkit.loadDocumentFromString((String)serverModelState));
            }
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not load server model from preferences", e);
        }
        try {
            String triggersState = this.getRJMXPreferences().get(TRIGGERS_MODEL_PREF, null);
            if (triggersState != null) {
                this.notificationModel.importFromXML(XmlToolkit.loadDocumentFromString((String)triggersState).getDocumentElement());
            }
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not load notification model from preferences", e);
        }
    }

    public void storeAllSettings() throws Exception {
        RJMXPlugin.getDefault().getRJMXPreferences().put(PREFERENCE_ATTRIBUTE_METADATA_MANAGER, StateToolkit.toXMLString((IStateful)this.metadataManager));
        this.getRJMXPreferences().put(SERVER_MODEL_PREF, XmlToolkit.storeDocumentToString((Document)this.serverModel.exportServers(new Server[0])));
        this.getRJMXPreferences().put(TRIGGERS_MODEL_PREF, XmlToolkit.storeDocumentToString((Document)this.notificationModel.exportToXml(null, true)));
        this.getRJMXPreferences().flush();
    }

    private void cleanServerPreferences() throws BackingStoreException {
        HashSet<String> serverIds = new HashSet<String>();
        Server[] serverArray = this.serverModel.elements();
        int n = serverArray.length;
        int n2 = 0;
        while (n2 < n) {
            Server server = serverArray[n2];
            serverIds.add(server.getServerHandle().getServerDescriptor().getGUID());
            ++n2;
        }
        Preferences serverPrefs = this.getRJMXPreferences().node("serverConfig");
        String[] stringArray = serverPrefs.childrenNames();
        int n3 = stringArray.length;
        n = 0;
        while (n < n3) {
            String serverId = stringArray[n];
            if (!serverIds.contains(serverId)) {
                serverPrefs.node(serverId).removeNode();
            }
            ++n;
        }
    }

    public static RJMXSingleton getDefault() {
        return INSTANCE;
    }

    private IEclipsePreferences getRJMXPreferences() {
        return RJMXPlugin.getDefault().getRJMXPreferences();
    }

    public NotificationRegistry getNotificationRegistry() {
        return this.notificationModel;
    }

    public <T> T getService(Class<T> clazz) {
        if (clazz == IMRIMetadataService.class) {
            return (T)this.metadataManager;
        }
        if (clazz == IServerModel.class) {
            return (T)this.serverModel;
        }
        if (clazz == ServerModel.class) {
            return (T)this.serverModel;
        }
        return null;
    }
}

