/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.actionprovider.internal;

import com.oracle.jmc.common.IDescribable;
import com.oracle.jmc.common.internal.IUserAction;
import com.oracle.jmc.core.IImageResource;
import com.oracle.jmc.core.Resource;
import com.oracle.jmc.rjmx.RJMXPlugin;
import com.oracle.jmc.rjmx.actionprovider.internal.ActionProvider;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;

public class ActionProviderDescriptor
extends ActionProvider
implements IDescribable,
IImageResource {
    private final IConfigurationElement element;
    private final Resource imageResource;

    public ActionProviderDescriptor(IConfigurationElement element) throws Exception {
        this.element = element;
        this.imageResource = new Resource(element.getDeclaringExtension().getContributor().getName(), element.getAttribute("icon"));
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public Resource getImageResource() {
        return this.imageResource;
    }

    public String getDescription() {
        return this.element.getAttribute("description");
    }

    public String getName() {
        return this.element.getAttribute("label");
    }

    public String toString() {
        return "label= " + this.getName() + " | " + this.getActions();
    }

    @Override
    public IUserAction getDefaultAction() {
        String attribute = this.element.getAttribute("doubleClickActionIndex");
        if (attribute != null) {
            try {
                Integer doubleClickActionIndex = Integer.parseInt(attribute);
                return (IUserAction)this.getActions().get(doubleClickActionIndex);
            }
            catch (NumberFormatException e) {
                RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not parse doubleClickActionIndex", e);
            }
        }
        return null;
    }
}

