/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.actionprovider.internal;

import com.oracle.jmc.common.internal.Executable;
import com.oracle.jmc.common.internal.IUserAction;
import com.oracle.jmc.core.AdapterUtil;
import com.oracle.jmc.core.IImageResource;
import com.oracle.jmc.core.Resource;
import com.oracle.jmc.rjmx.IServerHandle;
import com.oracle.jmc.rjmx.actionprovider.IActionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;

public class ActionDescriptor
implements IUserAction,
IAdaptable,
IImageResource {
    private final IConfigurationElement element;
    private final IServerHandle jvm;
    private Executable executable;
    private final Resource imageResource;

    public ActionDescriptor(IConfigurationElement element, IServerHandle jvm) {
        this.element = element;
        this.jvm = jvm;
        this.imageResource = new Resource(element.getDeclaringExtension().getContributor().getName(), element.getAttribute("icon"));
    }

    public String getDescription() {
        return this.element.getAttribute("description");
    }

    public String getName() {
        return this.element.getAttribute("label");
    }

    public String toString() {
        try {
            return "   Action= " + this.getName();
        }
        catch (Exception e) {
            return "   Action= " + this.getName() + " " + e;
        }
    }

    private synchronized Executable getExecutable() throws CoreException {
        if (this.executable == null) {
            this.executable = ((IActionFactory)this.element.createExecutableExtension("factory")).createAction(this.jvm);
        }
        return this.executable;
    }

    public void execute() throws Exception {
        this.getExecutable().execute();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IImageResource.class) {
            return this;
        }
        try {
            return AdapterUtil.getAdapter((Object)this.getExecutable(), (Class)adapter);
        }
        catch (CoreException e) {
            return null;
        }
    }

    public Resource getImageResource() {
        return this.imageResource;
    }
}

