/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx;

import com.oracle.jmc.common.version.JavaVersion;
import com.oracle.jmc.common.version.JavaVersionSupport;
import com.oracle.jmc.core.jvm.JVMDescriptor;
import com.oracle.jmc.core.jvm.JVMType;
import com.oracle.jmc.rjmx.ConnectionToolkit;
import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.IServerHandle;
import com.oracle.jmc.rjmx.internal.ServerToolkit;
import com.oracle.jmc.rjmx.messages.internal.Messages;
import com.oracle.jmc.rjmx.services.internal.HotspotManagementToolkit;
import javax.management.MBeanServerConnection;

public final class JVMSupportToolkit {
    private JVMSupportToolkit() {
        throw new IllegalArgumentException("Don't instantiate this toolkit");
    }

    public static String[] checkConsoleSupport(IConnectionHandle connection) {
        String title = null;
        String message = null;
        if (ConnectionToolkit.isJRockit(connection)) {
            title = Messages.JVMSupport_TITLE_JROCKIT_NOT_SUPPORTED;
            message = Messages.JVMSupport_MESSAGE_JROCKIT_NOT_SUPPORTED;
        } else if (!ConnectionToolkit.isHotSpot(connection)) {
            title = Messages.JVMSupport_TITLE_NOT_A_KNOWN_JVM;
            message = Messages.JVMSupport_MESSAGE_NOT_A_KNOWN_JVM;
        } else if (!ConnectionToolkit.isJavaVersionAboveOrEqual(connection, JavaVersionSupport.DIAGNOSTIC_COMMANDS_SUPPORTED)) {
            title = Messages.JVMSupport_TITLE_TOO_OLD_JVM_CONSOLE;
            message = Messages.JVMSupport_MESSAGE_TOO_OLD_JVM_CONSOLE;
        }
        if (title != null) {
            String[] returnInfo = new String[]{title, message};
            return returnInfo;
        }
        return new String[0];
    }

    public static boolean isFlightRecorderDisabled(IConnectionHandle connection, boolean explicitFlag) {
        try {
            boolean disabled;
            MBeanServerConnection server = connection.getServiceOrThrow(MBeanServerConnection.class);
            boolean bl = disabled = !Boolean.parseBoolean(HotspotManagementToolkit.getVMOption(server, "FlightRecorder").toString());
            if (explicitFlag) {
                return disabled && HotspotManagementToolkit.isVMOptionExplicit(server, "FlightRecorder");
            }
            return disabled;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getNoFlightRecorderErrorMessage(IConnectionHandle handle, boolean shortMessage) {
        if (ConnectionToolkit.isJRockit(handle)) {
            return JVMSupportToolkit.getJfrJRockitNotSupported(shortMessage);
        }
        if (!ConnectionToolkit.isHotSpot(handle)) {
            return JVMSupportToolkit.getJfrNonHotSpotNotSupported(shortMessage);
        }
        if (!ConnectionToolkit.isJavaVersionAboveOrEqual(handle, JavaVersionSupport.JFR_ENGINE_SUPPORTED)) {
            return JVMSupportToolkit.getJfrOldHotSpotNotSupported(shortMessage);
        }
        if (JVMSupportToolkit.isFlightRecorderDisabled(handle, true)) {
            return JVMSupportToolkit.getJfrDisabled(shortMessage);
        }
        return JVMSupportToolkit.getJfrNotEnabled(shortMessage);
    }

    public static String checkFlightRecorderSupport(IServerHandle handle, boolean shortMessage) {
        if (ServerToolkit.getJvmInfo(handle) != null) {
            JVMDescriptor jvmInfo = ServerToolkit.getJvmInfo(handle);
            if (jvmInfo.getJvmType() == null) {
                return null;
            }
            if (jvmInfo.getJvmType() == JVMType.JROCKIT) {
                return JVMSupportToolkit.getJfrJRockitNotSupported(shortMessage);
            }
            if (jvmInfo.getJvmType() == JVMType.UNKNOWN) {
                return null;
            }
            if (jvmInfo.getJvmType() != JVMType.HOTSPOT) {
                return JVMSupportToolkit.getJfrNonHotSpotNotSupported(shortMessage);
            }
            if (jvmInfo.getJavaVersion() == null) {
                return null;
            }
            if (!new JavaVersion(jvmInfo.getJavaVersion()).isGreaterOrEqualThan(JavaVersionSupport.JFR_ENGINE_SUPPORTED)) {
                return JVMSupportToolkit.getJfrOldHotSpotNotSupported(shortMessage);
            }
            if (!new JavaVersion(jvmInfo.getJavaVersion()).isGreaterOrEqualThan(JavaVersionSupport.JFR_FULLY_SUPPORTED)) {
                return JVMSupportToolkit.getJfrOldHotSpotNotFullySupported(shortMessage);
            }
        }
        return null;
    }

    private static String getJfrNotEnabled(boolean shortMessage) {
        return shortMessage ? Messages.JVMSupport_FLIGHT_RECORDER_NOT_ENABLED_SHORT : Messages.JVMSupport_FLIGHT_RECORDER_NOT_ENABLED;
    }

    private static String getJfrDisabled(boolean shortMessage) {
        return shortMessage ? Messages.JVMSupport_FLIGHT_RECORDER_DISABLED_SHORT : Messages.JVMSupport_FLIGHT_RECORDER_DISABLED;
    }

    private static String getJfrOldHotSpotNotSupported(boolean shortMessage) {
        return shortMessage ? Messages.JVMSupport_FLIGHT_RECORDER_NOT_SUPPORTED_OLD_HOTSPOT_SHORT : Messages.JVMSupport_FLIGHT_RECORDER_NOT_SUPPORTED_OLD_HOTSPOT;
    }

    private static String getJfrOldHotSpotNotFullySupported(boolean shortMessage) {
        return shortMessage ? Messages.JVMSupport_FLIGHT_RECORDER_NOT_FULLY_SUPPORTED_OLD_HOTSPOT_SHORT : Messages.JVMSupport_FLIGHT_RECORDER_NOT_FULLY_SUPPORTED_OLD_HOTSPOT;
    }

    private static String getJfrNonHotSpotNotSupported(boolean shortMessage) {
        return shortMessage ? Messages.JVMSupport_FLIGHT_RECORDER_NOT_SUPPORTED_NOT_HOTSPOT_SHORT : Messages.JVMSupport_FLIGHT_RECORDER_NOT_SUPPORTED_NOT_HOTSPOT;
    }

    private static String getJfrJRockitNotSupported(boolean shortMessage) {
        return shortMessage ? Messages.JVMSupport_JROCKIT_NOT_LONGER_SUPPORTED_SHORT : Messages.JVMSupport_JROCKIT_NOT_LONGER_SUPPORTED;
    }
}

