/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx;

import com.oracle.jmc.common.version.JavaVMVersionToolkit;
import com.oracle.jmc.common.version.JavaVersion;
import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.RJMXPlugin;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXServiceURL;

public final class ConnectionToolkit {
    public static final ObjectName RUNTIME_BEAN_NAME = ConnectionToolkit.createObjectName("java.lang:type=Runtime");
    public static final ObjectName MEMORY_BEAN_NAME = ConnectionToolkit.createObjectName("java.lang:type=Memory");
    public static final ObjectName THREAD_BEAN_NAME = ConnectionToolkit.createObjectName("java.lang:type=Threading");
    public static final ObjectName OPERATING_SYSTEM_BEAN_NAME = ConnectionToolkit.createObjectName("java.lang:type=OperatingSystem");

    private ConnectionToolkit() {
        throw new IllegalArgumentException("Don't instantiate this toolkit");
    }

    public static ObjectName createObjectName(String name) {
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            assert (false);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static MemoryMXBean getMemoryBean(MBeanServerConnection server) throws IOException {
        return ManagementFactory.newPlatformMXBeanProxy(server, "java.lang:type=Memory", MemoryMXBean.class);
    }

    public static RuntimeMXBean getRuntimeBean(MBeanServerConnection server) throws IOException {
        return ManagementFactory.newPlatformMXBeanProxy(server, "java.lang:type=Runtime", RuntimeMXBean.class);
    }

    public static ThreadMXBean getThreadBean(MBeanServerConnection server) throws IOException {
        return ManagementFactory.newPlatformMXBeanProxy(server, "java.lang:type=Threading", ThreadMXBean.class);
    }

    public static OperatingSystemMXBean getOperatingSystemBean(MBeanServerConnection server) throws IOException {
        return ManagementFactory.newPlatformMXBeanProxy(server, "java.lang:type=OperatingSystem", OperatingSystemMXBean.class);
    }

    public static Object invokeOperation(MBeanServerConnection server, ObjectName on, String operation, Object ... parameters) throws JMException, IOException {
        return server.invoke(on, operation, parameters, ConnectionToolkit.extractSignature(parameters));
    }

    private static String[] extractSignature(Object[] param) {
        String[] sig = new String[param.length];
        int i = 0;
        while (i < sig.length) {
            if (param[i].getClass() == Boolean.class) {
                sig[i] = Boolean.TYPE.getName();
            } else if (Number.class.isAssignableFrom(param[i].getClass())) {
                try {
                    sig[i] = ((Class)param[i].getClass().getField("TYPE").get(param[i])).getName();
                }
                catch (IllegalArgumentException e) {
                    throw new UndeclaredThrowableException(e);
                }
                catch (SecurityException e) {
                    throw new UndeclaredThrowableException(e);
                }
                catch (IllegalAccessException e) {
                    throw new UndeclaredThrowableException(e);
                }
                catch (NoSuchFieldException e) {
                    throw new UndeclaredThrowableException(e);
                }
            } else {
                sig[i] = CompositeData.class.isAssignableFrom(param[i].getClass()) ? CompositeData.class.getName() : (TabularData.class.isAssignableFrom(param[i].getClass()) ? TabularData.class.getName() : (List.class.isAssignableFrom(param[i].getClass()) ? List.class.getName() : param[i].getClass().getName()));
            }
            ++i;
        }
        return sig;
    }

    public static String getHostName(JMXServiceURL url) {
        if (url.getHost() == null || "".equals(url.getHost().trim())) {
            return ConnectionToolkit.deriveHost(url);
        }
        return url.getHost();
    }

    public static int getPort(JMXServiceURL url) {
        if (url.getPort() <= 0) {
            return ConnectionToolkit.derivePort(url);
        }
        return url.getPort();
    }

    private static String deriveHost(JMXServiceURL url) {
        StringTokenizer st = new StringTokenizer(url.getURLPath(), ":/");
        if (st.countTokens() == 5) {
            int i = 0;
            while (i < 2) {
                st.nextToken();
                ++i;
            }
            String host = st.nextToken();
            return host;
        }
        return "unknown";
    }

    private static int derivePort(JMXServiceURL url) {
        StringTokenizer st = new StringTokenizer(url.getURLPath(), ":/");
        if (st.countTokens() == 5) {
            int i = 0;
            while (i < 3) {
                st.nextToken();
                ++i;
            }
            String port = st.nextToken();
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return 0;
    }

    public static JMXServiceURL createServiceURL(String host, int port) throws MalformedURLException {
        int actualPort = port != -1 ? port : 7091;
        return new JMXServiceURL("rmi", "", 0, "/jndi/rmi://" + host + ':' + actualPort + "/jmxrmi");
    }

    public static int getDefaultPort() {
        return 7091;
    }

    public static boolean isJRockit(IConnectionHandle connectionHandle) {
        String vmName = ConnectionToolkit.getVMName(connectionHandle);
        return JavaVMVersionToolkit.isJRockitJVMName((String)vmName);
    }

    public static boolean isHotSpot(IConnectionHandle connectionHandle) {
        String vmName = ConnectionToolkit.getVMName(connectionHandle);
        return vmName != null && JavaVMVersionToolkit.isHotspotJVMName((String)vmName);
    }

    public static boolean isJavaVersionAboveOrEqual(IConnectionHandle connectionHandle, JavaVersion minVersion) {
        JavaVersion version = ConnectionToolkit.getJavaVersion(connectionHandle);
        return version != null ? version.isGreaterOrEqualThan(minVersion) : true;
    }

    private static String getVMName(IConnectionHandle connectionHandle) {
        MBeanServerConnection connection = connectionHandle.getServiceOrDummy(MBeanServerConnection.class);
        try {
            return ConnectionToolkit.getRuntimeBean(connection).getVmName();
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.INFO, "Could not check the JVM name!", e);
            return null;
        }
    }

    private static JavaVersion getJavaVersion(IConnectionHandle connectionHandle) {
        try {
            MBeanServerConnection server = connectionHandle.getServiceOrThrow(MBeanServerConnection.class);
            Map<String, String> serverProps = ConnectionToolkit.getRuntimeBean(server).getSystemProperties();
            String javaVersion = serverProps.get("java.version");
            if (javaVersion != null) {
                return new JavaVersion(javaVersion);
            }
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "System Properties from " + connectionHandle.getDescription() + " contained no java.version property!");
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not check the java.version from System Properties!", e);
        }
        return null;
    }
}

