/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.rules.extensionprovider;

import com.oracle.jmc.flightrecorder.rules.IRule;
import com.oracle.jmc.flightrecorder.rules.RuleRegistry;
import com.oracle.jmc.flightrecorder.rules.internal.IRuleProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class ExtensionRuleProvider
implements IRuleProvider {
    private static final String EXTENSION_POINT = "com.oracle.jmc.flightrecorder.rules.ruleProvider";

    public Collection<IRule> getRules() {
        Logger logger = Logger.getLogger(RuleRegistry.class.getName());
        ArrayList<IRule> rules = new ArrayList<IRule>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            Bundle bundle = Platform.getBundle((String)element.getContributor().getName());
            ClassLoader cl = ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
            ServiceLoader<IRule> ruleLoader = ServiceLoader.load(IRule.class, cl);
            Iterator<IRule> ruleIter = ruleLoader.iterator();
            while (ruleIter.hasNext()) {
                try {
                    IRule rule = ruleIter.next();
                    rules.add(rule);
                }
                catch (ServiceConfigurationError e) {
                    logger.log(Level.WARNING, "Could not create IRule instance specified in a JSL services file", e);
                }
            }
            ++n2;
        }
        return rules;
    }
}

